/************************************************************************************************/
/* Stata User File for H209 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H209.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H209.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H209.DO                                               */
/* The program below will output the Stata dataset H209.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-7
  int    PID 8-10
  str    DUPERSID 11-20
  byte   PANEL 21-22
  str    FAMID31 23-24
  str    FAMID42 25-26
  str    FAMID53 27-28
  str    FAMID18 29-30
  str    FAMIDYR 31-32
  str    CPSFAMID 33-34
  byte   FCSZ1231 35-36
  byte   FCRP1231 37-38
  str    RULETR31 39-40
  str    RULETR42 41-42
  str    RULETR53 43-44
  str    RULETR18 45-47
  byte   RUSIZE31 48-49
  byte   RUSIZE42 50-51
  byte   RUSIZE53 52-53
  byte   RUSIZE18 54-55
  byte   RUCLAS31 56-57
  byte   RUCLAS42 58-59
  byte   RUCLAS53 60-61
  byte   RUCLAS18 62-62
  byte   FAMSZE31 63-64
  byte   FAMSZE42 65-66
  byte   FAMSZE53 67-68
  byte   FAMSZE18 69-70
  byte   FMRS1231 71-72
  byte   FAMS1231 73-74
  byte   FAMSZEYR 75-76
  byte   FAMRFPYR 77-77
  byte   REGION31 78-79
  byte   REGION42 80-81
  byte   REGION53 82-83
  byte   REGION18 84-85
  int    REFPRS31 86-88
  int    REFPRS42 89-91
  int    REFPRS53 92-94
  int    REFPRS18 95-97
  byte   RESP31 98-98
  byte   RESP42 99-99
  byte   RESP53 100-100
  byte   RESP18 101-101
  byte   PROXY31 102-103
  byte   PROXY42 104-105
  byte   PROXY53 106-107
  byte   PROXY18 108-108
  byte   INTVLANG 109-110
  byte   BEGRFM31 111-112
  int    BEGRFY31 113-116
  byte   ENDRFM31 117-118
  int    ENDRFY31 119-122
  byte   BEGRFM42 123-124
  int    BEGRFY42 125-128
  byte   ENDRFM42 129-130
  int    ENDRFY42 131-134
  byte   BEGRFM53 135-136
  int    BEGRFY53 137-140
  byte   ENDRFM53 141-142
  int    ENDRFY53 143-146
  byte   ENDRFM18 147-148
  int    ENDRFY18 149-152
  byte   KEYNESS 153-153
  byte   INSCOP31 154-154
  byte   INSCOP42 155-155
  byte   INSCOP53 156-156
  byte   INSCOP18 157-157
  byte   INSC1231 158-158
  byte   INSCOPE 159-159
  byte   ELGRND31 160-160
  byte   ELGRND42 161-161
  byte   ELGRND53 162-162
  byte   ELGRND18 163-163
  byte   PSTATS31 164-165
  byte   PSTATS42 166-167
  byte   PSTATS53 168-169
  str    RURSLT31 170-171
  str    RURSLT42 172-173
  str    RURSLT53 174-175
  byte   AGE31X 176-177
  byte   AGE42X 178-179
  byte   AGE53X 180-181
  byte   AGE18X 182-183
  byte   AGELAST 184-185
  byte   DOBMM 186-187
  int    DOBYY 188-191
  byte   SEX 192-192
  byte   RACEV1X 193-193
  byte   RACEV2X 194-195
  byte   RACEAX 196-196
  byte   RACEBX 197-197
  byte   RACEWX 198-198
  byte   RACETHX 199-199
  byte   HISPANX 200-200
  byte   HISPNCAT 201-201
  byte   MARRY31X 202-203
  byte   MARRY42X 204-205
  byte   MARRY53X 206-207
  byte   MARRY18X 208-209
  int    SPOUID31 210-212
  int    SPOUID42 213-215
  int    SPOUID53 216-218
  int    SPOUID18 219-221
  int    SPOUIN31 222-224
  int    SPOUIN42 225-227
  int    SPOUIN53 228-230
  int    SPOUIN18 231-233
  int    EDUCYR 234-236
  int    HIDEG 237-239
  byte   FTSTU31X 240-241
  byte   FTSTU42X 242-243
  byte   FTSTU53X 244-245
  byte   FTSTU18X 246-247
  byte   ACTDTY31 248-249
  byte   ACTDTY42 250-251
  byte   ACTDTY53 252-253
  int    HONRDC31 254-256
  int    HONRDC42 257-259
  byte   REFRL31X 260-261
  byte   REFRL42X 262-263
  byte   REFRL53X 264-265
  byte   REFRL18X 266-267
  int    OTHLANG 268-270
  byte   LANGSPK 271-272
  int    HWELLSPE 273-275
  int    OTHLGSPK 276-278
  byte   WHTLGSPK 279-280
  byte   HWELLSPK 281-282
  int    BORNUSA 283-285
  byte   YRSINUS 286-287
  int    MOPID31X 288-290
  int    MOPID42X 291-293
  int    MOPID53X 294-296
  int    DAPID31X 297-299
  int    DAPID42X 300-302
  int    DAPID53X 303-305
  byte   RTHLTH31 306-307
  byte   RTHLTH42 308-309
  byte   RTHLTH53 310-311
  byte   MNHLTH31 312-313
  byte   MNHLTH42 314-315
  byte   MNHLTH53 316-317
  int    HIBPDX 318-320
  byte   HIBPAGED 321-322
  byte   BPMLDX 323-324
  int    CHDDX 325-327
  byte   CHDAGED 328-329
  int    ANGIDX 330-332
  byte   ANGIAGED 333-334
  int    MIDX 335-337
  byte   MIAGED 338-339
  int    OHRTDX 340-342
  byte   OHRTAGED 343-344
  byte   OHRTTYPE 345-346
  int    STRKDX 347-349
  byte   STRKAGED 350-351
  int    EMPHDX 352-354
  byte   EMPHAGED 355-356
  byte   CHBRON31 357-358
  int    CHOLDX 359-361
  byte   CHOLAGED 362-363
  int    CANCERDX 364-366
  byte   CABLADDR 367-368
  byte   CABREAST 369-370
  byte   CACERVIX 371-372
  byte   CACOLON 373-374
  byte   CALUNG 375-376
  byte   CALYMPH 377-378
  byte   CAMELANO 379-380
  byte   CAOTHER 381-382
  byte   CAPROSTA 383-384
  byte   CASKINNM 385-386
  byte   CASKINDK 387-388
  byte   CAUTERUS 389-390
  int    DIABDX_M18 391-393
  byte   DIABAGED 394-395
  byte   JTPAIN31_M18 396-397
  int    ARTHDX 398-400
  byte   ARTHTYPE 401-402
  int    ARTHAGED 403-405
  byte   ASTHDX 406-407
  byte   ASTHAGED 408-409
  int    ASSTIL31 410-412
  int    ASATAK31 413-415
  byte   ASTHEP31 416-417
  int    ASACUT31 418-420
  byte   ASMRCN31 421-422
  int    ASPREV31 423-425
  byte   ASDALY31 426-427
  int    ASPKFL31 428-430
  byte   ASEVFL31 431-432
  byte   ASWNFL31 433-434
  int    ADHDADDX 435-437
  byte   ADHDAGED 438-439
  byte   IADLHP31 440-441
  byte   ADLHLP31 442-443
  byte   AIDHLP31 444-445
  byte   WLKLIM31 446-447
  byte   LFTDIF31 448-449
  byte   STPDIF31 450-451
  byte   WLKDIF31 452-453
  byte   MILDIF31 454-455
  byte   STNDIF31 456-457
  byte   BENDIF31 458-459
  byte   RCHDIF31 460-461
  byte   FNGRDF31 462-463
  byte   ACTLIM31 464-465
  byte   WRKLIM31 466-467
  byte   HSELIM31 468-469
  byte   SCHLIM31 470-471
  byte   UNABLE31 472-473
  byte   SOCLIM31 474-475
  byte   COGLIM31 476-477
  byte   DFHEAR42 478-479
  byte   DFSEE42 480-481
  byte   DFCOG42 482-483
  byte   DFWLKC42 484-485
  byte   DFDRSB42 486-487
  byte   DFERND42 488-489
  int    ANYLMI18 490-492
  int    CHPMED42 493-495
  byte   CHPMHB42 496-497
  byte   CHPMCN42 498-499
  int    CHSERV42 500-502
  byte   CHSRHB42 503-504
  byte   CHSRCN42 505-506
  int    CHLIMI42 507-509
  byte   CHLIHB42 510-511
  byte   CHLICO42 512-513
  int    CHTHER42 514-516
  byte   CHTHHB42 517-518
  byte   CHTHCO42 519-520
  int    CHCOUN42 521-523
  byte   CHEMPB42 524-525
  byte   CSHCN42 526-527
  int    MESHGT42 528-530
  byte   WHNHGT42 531-532
  int    MESWGT42 533-535
  byte   WHNWGT42 536-537
  double CHBMIX42 538-542
  int    MESVIS42 543-545
  int    EATHLT42 546-548
  byte   WHNEAT42 549-550
  int    PHYSCL42 551-553
  byte   WHNPHY42 554-555
  byte   SAFEST42 556-557
  byte   WHNSAF42 558-559
  int    BOOST42 560-562
  byte   WHNBST42 563-564
  int    LAPBLT42 565-567
  byte   WHNLAP42 568-569
  int    HELMET42 570-572
  byte   WHNHEL42 573-574
  int    NOSMOK42 575-577
  byte   WHNSMK42 578-579
  int    TIMALN42 580-582
  byte   LSTETH53 583-584
  byte   PHYEXE53 585-586
  byte   OFTSMK53 587-588
  byte   SAQELIG 589-589
  int    ADSEX42 590-592
  int    ADAGE42 593-595
  int    ADPROX42 596-598
  int    ADGENH42 599-601
  int    ADDAYA42 602-604
  int    ADCLIM42 605-607
  int    ADACLS42 608-610
  int    ADWKLM42 611-613
  int    ADEMLS42 614-616
  int    ADMWCF42 617-619
  int    ADPAIN42 620-622
  int    ADPCFL42 623-625
  int    ADENGY42 626-628
  int    ADPRST42 629-631
  int    ADSOCA42 632-634
  double VPCS42 635-640
  double VMCS42 641-646
  byte   VRFLAG42 647-648
  int    ADNERV42 649-651
  int    ADHOPE42 652-654
  int    ADREST42 655-657
  int    ADSAD42 658-660
  int    ADEFRT42 661-663
  int    ADWRTH42 664-666
  int    K6SUM42 667-669
  int    ADINTR42 670-672
  int    ADDPRS42 673-675
  int    PHQ242 676-678
  int    ADBRTC42 679-681
  int    ADMDVT42 682-684
  int    ADFLST42 685-687
  int    ADWGHD42 688-690
  double ADBMI42 691-695
  int    ADWTAD42 696-698
  int    ADKALC42 699-701
  int    ADRNK542 702-704
  int    ADRNK442 705-707
  int    ADSTAL42 708-710
  int    ADTBAC42 711-713
  int    ADOFTB42 714-716
  int    ADQTTB42 717-719
  int    ADQTMD42 720-722
  int    ADQTHP42 723-725
  int    ADMOOD42 726-728
  int    ADBPCK42 729-731
  int    ADCHLC42 732-734
  int    ADPNEU42 735-737
  int    ADSHNG42 738-740
  int    ADNOAP42 741-743
  int    ADDSCU42 744-746
  int    ADCOLN42 747-749
  int    ADCLNS42 750-752
  int    ADSGMD42 753-755
  int    ADBLDS42 756-758
  int    ADPROS42 759-761
  int    ADPSAG42 762-764
  int    ADUTRM42 765-767
  int    ADPAP42 768-770
  int    ADPAPG42 771-773
  int    ADOSTP42 774-776
  int    ADBNDN42 777-779
  int    ADBRST42 780-782
  int    ADMMGR42 783-785
  int    ADCMPM42 786-788
  int    ADCMPY42 789-792
  byte   ADLANG42 793-794
  byte   VSAQELIG 795-795
  byte   VACTDY53 796-797
  int    VAPRHT53 798-800
  int    VACOPD53 801-803
  int    VADERM53 804-806
  int    VAGERD53 807-809
  int    VAHRLS53 810-812
  int    VABACK53 813-815
  int    VAJTPN53 816-818
  int    VARTHR53 819-821
  int    VAGOUT53 822-824
  int    VANECK53 825-827
  int    VATMD53 828-830
  int    VAPTSD53 831-833
  int    VALCOH53 834-836
  int    VABIPL53 837-839
  int    VADEPR53 840-842
  int    VAMOOD53 843-845
  int    VAPROS53 846-848
  int    VARHAB53 849-851
  int    VAMNHC53 852-854
  int    VAGCNS53 855-857
  int    VARXMD53 858-860
  int    VACRGV53 861-863
  int    VAMOBL53 864-866
  int    VACOST53 867-869
  int    VARECM53 870-872
  int    VAREP53 873-875
  int    VAWAIT53 876-878
  int    VALOCT53 879-881
  int    VANTWK53 882-884
  int    VANEED53 885-887
  int    VAOUT53 888-890
  int    VAPAST53 891-893
  int    VACOMP53 894-896
  int    VAMREC53 897-899
  int    VAGTRC53 900-902
  int    VACARC53 903-905
  int    VAPROB53 906-908
  int    VACARE53 909-911
  int    VAPACT53 912-914
  int    VAPCPR53 915-917
  int    VAPROV53 918-920
  int    VAPCOT53 921-923
  int    VAPCCO53 924-926
  int    VAPCRC53 927-929
  byte   VAPCSN53 930-931
  int    VAPCRF53 932-934
  int    VAPCSO53 935-937
  int    VAPCOU53 938-940
  byte   VAPCUN53 941-942
  int    VASPCL53 943-945
  int    VASPMH53 946-948
  int    VASPOU53 949-951
  int    VASPUN53 952-954
  int    VACMPM53 955-957
  int    VACMPY53 958-961
  int    VAPROX53 962-964
  byte   DCSELIG 965-965
  byte   DSDIA53 966-967
  int    DSA1C53 968-970
  int    DSFT1953 971-973
  int    DSFT1853 974-976
  int    DSFT1753 977-979
  int    DSFB1753 980-982
  int    DSFTNV53 983-985
  int    DSEY1953 986-988
  int    DSEY1853 989-991
  int    DSEY1753 992-994
  int    DSEB1753 995-997
  int    DSEYNV53 998-1000
  int    DSCH1953 1001-1003
  int    DSCH1853 1004-1006
  int    DSCH1753 1007-1009
  int    DSCB1753 1010-1012
  int    DSCHNV53 1013-1015
  int    DSFL1953 1016-1018
  int    DSFL1853 1019-1021
  int    DSFL1753 1022-1024
  int    DSVB1753 1025-1027
  int    DSFLNV53 1028-1030
  int    DSKIDN53 1031-1033
  int    DSEYPR53 1034-1036
  int    DSDIET53 1037-1039
  int    DSMED53 1040-1042
  int    DSINSU53 1043-1045
  byte   DSCPCP53 1046-1047
  byte   DSCNPC53 1048-1049
  byte   DSCPHN53 1050-1051
  byte   DSCINT53 1052-1053
  byte   DSCGRP53 1054-1055
  int    DSCONF53 1056-1058
  int    DSPRX53 1059-1061
  int    DDNWRK18 1062-1064
  int    OTHDYS18 1065-1067
  int    OTHNDD18 1068-1070
  byte   ACCELI42 1071-1072
  byte   HAVEUS42 1073-1074
  byte   PRACTP42 1075-1076
  byte   YNOUSC42_M18 1077-1078
  byte   PROVTY42_M18 1079-1080
  byte   PLCTYP42 1081-1082
  byte   TMTKUS42 1083-1084
  byte   TYPEPE42 1085-1086
  byte   LOCATN42 1087-1088
  byte   HSPLAP42 1089-1090
  byte   WHITPR42 1091-1092
  byte   BLCKPR42 1093-1094
  byte   ASIANP42 1095-1096
  byte   NATAMP42 1097-1098
  byte   PACISP42 1099-1100
  byte   OTHRCP42 1101-1102
  byte   GENDRP42 1103-1104
  byte   PHNREG42 1105-1106
  byte   OFFHOU42 1107-1108
  byte   AFTHOU42 1109-1110
  byte   TREATM42 1111-1112
  byte   DECIDE42 1113-1114
  byte   EXPLOP42 1115-1116
  byte   PRVSPK42 1117-1118
  byte   DLAYCA42 1119-1120
  byte   AFRDCA42 1121-1122
  byte   DLAYDN42 1123-1124
  byte   AFRDDN42 1125-1126
  byte   DLAYPM42 1127-1128
  byte   AFRDPM42 1129-1130
  int    EMPST31 1131-1133
  int    EMPST42 1134-1136
  int    EMPST53 1137-1139
  byte   RNDFLG31 1140-1141
  int    MORJOB31 1142-1144
  int    MORJOB42 1145-1147
  int    MORJOB53 1148-1150
  int    EVRWRK 1151-1153
  double HRWG31X 1154-1159
  double HRWG42X 1160-1165
  double HRWG53X 1166-1171
  byte   HRWGIM31 1172-1172
  byte   HRWGIM42 1173-1173
  byte   HRWGIM53 1174-1174
  int    HRHOW31 1175-1177
  int    HRHOW42 1178-1180
  int    HRHOW53 1181-1183
  int    DIFFWG31 1184-1186
  int    DIFFWG42 1187-1189
  int    DIFFWG53 1190-1192
  double NHRWG31 1193-1198
  double NHRWG42 1199-1204
  double NHRWG53 1205-1210
  int    HOUR31 1211-1213
  int    HOUR42 1214-1216
  int    HOUR53 1217-1219
  int    TEMPJB31 1220-1222
  int    TEMPJB42 1223-1225
  int    TEMPJB53 1226-1228
  int    SSNLJB31 1229-1231
  int    SSNLJB42 1232-1234
  int    SSNLJB53 1235-1237
  int    SELFCM31 1238-1240
  int    SELFCM42 1241-1243
  int    SELFCM53 1244-1246
  int    DISVW31X 1247-1249
  int    DISVW42X 1250-1252
  int    DISVW53X 1253-1255
  int    CHOIC31 1256-1258
  int    CHOIC42 1259-1261
  int    CHOIC53 1262-1264
  int    INDCAT31 1265-1267
  int    INDCAT42 1268-1270
  int    INDCAT53 1271-1273
  int    NUMEMP31 1274-1276
  int    NUMEMP42 1277-1279
  int    NUMEMP53 1280-1282
  int    MORE31 1283-1285
  int    MORE42 1286-1288
  int    MORE53 1289-1291
  int    UNION31 1292-1294
  int    UNION42 1295-1297
  int    UNION53 1298-1300
  int    NWK31 1301-1303
  byte   NWK42 1304-1305
  byte   NWK53 1306-1307
  int    CHGJ3142 1308-1310
  int    CHGJ4253 1311-1313
  int    YCHJ3142 1314-1316
  int    YCHJ4253 1317-1319
  int    STJBMM31 1320-1322
  int    STJBYY31 1323-1326
  int    STJBMM42 1327-1329
  int    STJBYY42 1330-1333
  int    STJBMM53 1334-1336
  int    STJBYY53 1337-1340
  int    EVRETIRE 1341-1343
  int    OCCCAT31 1344-1346
  int    OCCCAT42 1347-1349
  int    OCCCAT53 1350-1352
  int    PAYVAC31 1353-1355
  int    PAYVAC42 1356-1358
  int    PAYVAC53 1359-1361
  int    SICPAY31 1362-1364
  int    SICPAY42 1365-1367
  int    SICPAY53 1368-1370
  int    PAYDR31 1371-1373
  int    PAYDR42 1374-1376
  int    PAYDR53 1377-1379
  int    RETPLN31 1380-1382
  int    RETPLN42 1383-1385
  int    RETPLN53 1386-1388
  int    BSNTY31 1389-1391
  int    BSNTY42 1392-1394
  int    BSNTY53 1395-1397
  int    JOBORG31 1398-1400
  int    JOBORG42 1401-1403
  int    JOBORG53 1404-1406
  int    HELD31X 1407-1409
  int    HELD42X 1410-1412
  int    HELD53X 1413-1415
  int    OFFER31X 1416-1418
  int    OFFER42X 1419-1421
  int    OFFER53X 1422-1424
  int    OFREMP31 1425-1427
  int    OFREMP42 1428-1430
  int    OFREMP53 1431-1433
  byte   EMPST31H 1434-1435
  byte   EMPST42H 1436-1437
  byte   EMPST53H 1438-1439
  byte   SLFCM31H 1440-1441
  byte   SLFCM42H 1442-1443
  byte   SLFCM53H 1444-1445
  int    NMEMP31H 1446-1448
  int    NMEMP42H 1449-1451
  int    NMEMP53H 1452-1454
  byte   MORE31H 1455-1456
  byte   MORE42H 1457-1458
  byte   MORE53H 1459-1460
  byte   INDCT31H 1461-1462
  byte   INDCT42H 1463-1464
  byte   INDCT53H 1465-1466
  byte   OCCCT31H 1467-1468
  byte   OCCCT42H 1469-1470
  byte   OCCCT53H 1471-1472
  int    HOUR31H 1473-1475
  int    HOUR42H 1476-1478
  int    HOUR53H 1479-1481
  byte   JBORG31H 1482-1483
  byte   JBORG42H 1484-1485
  byte   JBORG53H 1486-1487
  byte   UNION31H 1488-1489
  byte   UNION42H 1490-1491
  byte   UNION53H 1492-1493
  byte   BSNTY31H 1494-1495
  byte   BSNTY42H 1496-1497
  byte   BSNTY53H 1498-1499
  double HRWG31H 1500-1505
  double HRWG42H 1506-1511
  double HRWG53H 1512-1517
  byte   CMJHLD31 1518-1519
  byte   CMJHLD42 1520-1521
  byte   CMJHLD53 1522-1523
  byte   OFFER31H 1524-1525
  byte   OFFER42H 1526-1527
  byte   OFFER53H 1528-1529
  byte   OFEMP31H 1530-1531
  byte   OFEMP42H 1532-1533
  byte   OFEMP53H 1534-1535
  byte   PYVAC31H 1536-1537
  byte   PYVAC42H 1538-1539
  byte   PYVAC53H 1540-1541
  byte   SCPAY31H 1542-1543
  byte   SCPAY42H 1544-1545
  byte   SCPAY53H 1546-1547
  byte   PAYDR31H 1548-1549
  byte   PAYDR42H 1550-1551
  byte   PAYDR53H 1552-1553
  byte   RTPLN31H 1554-1555
  byte   RTPLN42H 1556-1557
  byte   RTPLN53H 1558-1559
  byte   FILEDR18 1560-1561
  byte   WILFIL18 1562-1563
  byte   FLSTAT18 1564-1565
  byte   FILER18 1566-1567
  byte   JTINRU18 1568-1569
  int    JNTPID18 1570-1572
  byte   TAXFRM18 1573-1574
  byte   FOODST18 1575-1576
  byte   FOODMN18 1577-1578
  int    FOODVL18 1579-1582
  long   TTLP18X 1583-1589
  long   FAMINC18 1590-1596
  byte   POVCAT18 1597-1597
  double POVLEV18 1598-1609
  long   WAGEP18X 1610-1615
  byte   WAGIMP18 1616-1616
  long   BUSNP18X 1617-1622
  byte   BUSIMP18 1623-1623
  long   UNEMP18X 1624-1628
  byte   UNEIMP18 1629-1629
  long   WCMPP18X 1630-1634
  byte   WCPIMP18 1635-1635
  long   INTRP18X 1636-1640
  byte   INTIMP18 1641-1641
  long   DIVDP18X 1642-1646
  byte   DIVIMP18 1647-1647
  long   SALEP18X 1648-1654
  byte   SALIMP18 1655-1655
  long   PENSP18X 1656-1660
  byte   PENIMP18 1661-1661
  long   SSECP18X 1662-1666
  byte   SSCIMP18 1667-1667
  long   TRSTP18X 1668-1674
  byte   TRTIMP18 1675-1675
  long   VETSP18X 1676-1680
  byte   VETIMP18 1681-1681
  long   IRASP18X 1682-1686
  byte   IRAIMP18 1687-1687
  long   ALIMP18X 1688-1692
  byte   ALIIMP18 1693-1693
  long   CHLDP18X 1694-1698
  byte   CHLIMP18 1699-1699
  long   CASHP18X 1700-1704
  byte   CSHIMP18 1705-1705
  long   SSIP18X 1706-1710
  byte   SSIIMP18 1711-1711
  long   PUBP18X 1712-1716
  byte   PUBIMP18 1717-1717
  long   OTHRP18X 1718-1723
  byte   OTHIMP18 1724-1724
  str    HIEUIDX 1725-1733
  byte   TRIJA18X 1734-1735
  byte   TRIFE18X 1736-1737
  byte   TRIMA18X 1738-1739
  byte   TRIAP18X 1740-1741
  byte   TRIMY18X 1742-1743
  byte   TRIJU18X 1744-1745
  byte   TRIJL18X 1746-1747
  byte   TRIAU18X 1748-1749
  byte   TRISE18X 1750-1751
  byte   TRIOC18X 1752-1753
  byte   TRINO18X 1754-1755
  byte   TRIDE18X 1756-1757
  byte   MCRJA18 1758-1759
  byte   MCRFE18 1760-1761
  byte   MCRMA18 1762-1763
  byte   MCRAP18 1764-1765
  byte   MCRMY18 1766-1767
  byte   MCRJU18 1768-1769
  byte   MCRJL18 1770-1771
  byte   MCRAU18 1772-1773
  byte   MCRSE18 1774-1775
  byte   MCROC18 1776-1777
  byte   MCRNO18 1778-1779
  byte   MCRDE18 1780-1781
  byte   MCRJA18X 1782-1783
  byte   MCRFE18X 1784-1785
  byte   MCRMA18X 1786-1787
  byte   MCRAP18X 1788-1789
  byte   MCRMY18X 1790-1791
  byte   MCRJU18X 1792-1793
  byte   MCRJL18X 1794-1795
  byte   MCRAU18X 1796-1797
  byte   MCRSE18X 1798-1799
  byte   MCROC18X 1800-1801
  byte   MCRNO18X 1802-1803
  byte   MCRDE18X 1804-1805
  byte   MCDJA18 1806-1807
  byte   MCDFE18 1808-1809
  byte   MCDMA18 1810-1811
  byte   MCDAP18 1812-1813
  byte   MCDMY18 1814-1815
  byte   MCDJU18 1816-1817
  byte   MCDJL18 1818-1819
  byte   MCDAU18 1820-1821
  byte   MCDSE18 1822-1823
  byte   MCDOC18 1824-1825
  byte   MCDNO18 1826-1827
  byte   MCDDE18 1828-1829
  byte   MCDJA18X 1830-1831
  byte   MCDFE18X 1832-1833
  byte   MCDMA18X 1834-1835
  byte   MCDAP18X 1836-1837
  byte   MCDMY18X 1838-1839
  byte   MCDJU18X 1840-1841
  byte   MCDJL18X 1842-1843
  byte   MCDAU18X 1844-1845
  byte   MCDSE18X 1846-1847
  byte   MCDOC18X 1848-1849
  byte   MCDNO18X 1850-1851
  byte   MCDDE18X 1852-1853
  byte   GVAJA18 1854-1855
  byte   GVAFE18 1856-1857
  byte   GVAMA18 1858-1859
  byte   GVAAP18 1860-1861
  byte   GVAMY18 1862-1863
  byte   GVAJU18 1864-1865
  byte   GVAJL18 1866-1867
  byte   GVAAU18 1868-1869
  byte   GVASE18 1870-1871
  byte   GVAOC18 1872-1873
  byte   GVANO18 1874-1875
  byte   GVADE18 1876-1877
  byte   GVBJA18 1878-1879
  byte   GVBFE18 1880-1881
  byte   GVBMA18 1882-1883
  byte   GVBAP18 1884-1885
  byte   GVBMY18 1886-1887
  byte   GVBJU18 1888-1889
  byte   GVBJL18 1890-1891
  byte   GVBAU18 1892-1893
  byte   GVBSE18 1894-1895
  byte   GVBOC18 1896-1897
  byte   GVBNO18 1898-1899
  byte   GVBDE18 1900-1901
  byte   GVCJA18 1902-1903
  byte   GVCFE18 1904-1905
  byte   GVCMA18 1906-1907
  byte   GVCAP18 1908-1909
  byte   GVCMY18 1910-1911
  byte   GVCJU18 1912-1913
  byte   GVCJL18 1914-1915
  byte   GVCAU18 1916-1917
  byte   GVCSE18 1918-1919
  byte   GVCOC18 1920-1921
  byte   GVCNO18 1922-1923
  byte   GVCDE18 1924-1925
  byte   VAPJA18 1926-1927
  byte   VAPFE18 1928-1929
  byte   VAPMA18 1930-1931
  byte   VAPAP18 1932-1933
  byte   VAPMY18 1934-1935
  byte   VAPJU18 1936-1937
  byte   VAPJL18 1938-1939
  byte   VAPAU18 1940-1941
  byte   VAPSE18 1942-1943
  byte   VAPOC18 1944-1945
  byte   VAPNO18 1946-1947
  byte   VAPDE18 1948-1949
  byte   IHSJA18 1950-1951
  byte   IHSFE18 1952-1953
  byte   IHSMA18 1954-1955
  byte   IHSAP18 1956-1957
  byte   IHSMY18 1958-1959
  byte   IHSJU18 1960-1961
  byte   IHSJL18 1962-1963
  byte   IHSAU18 1964-1965
  byte   IHSSE18 1966-1967
  byte   IHSOC18 1968-1969
  byte   IHSNO18 1970-1971
  byte   IHSDE18 1972-1973
  byte   PUBJA18X 1974-1975
  byte   PUBFE18X 1976-1977
  byte   PUBMA18X 1978-1979
  byte   PUBAP18X 1980-1981
  byte   PUBMY18X 1982-1983
  byte   PUBJU18X 1984-1985
  byte   PUBJL18X 1986-1987
  byte   PUBAU18X 1988-1989
  byte   PUBSE18X 1990-1991
  byte   PUBOC18X 1992-1993
  byte   PUBNO18X 1994-1995
  byte   PUBDE18X 1996-1997
  byte   PEGJA18 1998-1999
  byte   PEGFE18 2000-2001
  byte   PEGMA18 2002-2003
  byte   PEGAP18 2004-2005
  byte   PEGMY18 2006-2007
  byte   PEGJU18 2008-2009
  byte   PEGJL18 2010-2011
  byte   PEGAU18 2012-2013
  byte   PEGSE18 2014-2015
  byte   PEGOC18 2016-2017
  byte   PEGNO18 2018-2019
  byte   PEGDE18 2020-2021
  byte   PDKJA18 2022-2023
  byte   PDKFE18 2024-2025
  byte   PDKMA18 2026-2027
  byte   PDKAP18 2028-2029
  byte   PDKMY18 2030-2031
  byte   PDKJU18 2032-2033
  byte   PDKJL18 2034-2035
  byte   PDKAU18 2036-2037
  byte   PDKSE18 2038-2039
  byte   PDKOC18 2040-2041
  byte   PDKNO18 2042-2043
  byte   PDKDE18 2044-2045
  byte   PNGJA18 2046-2047
  byte   PNGFE18 2048-2049
  byte   PNGMA18 2050-2051
  byte   PNGAP18 2052-2053
  byte   PNGMY18 2054-2055
  byte   PNGJU18 2056-2057
  byte   PNGJL18 2058-2059
  byte   PNGAU18 2060-2061
  byte   PNGSE18 2062-2063
  byte   PNGOC18 2064-2065
  byte   PNGNO18 2066-2067
  byte   PNGDE18 2068-2069
  byte   POGJA18 2070-2071
  byte   POGFE18 2072-2073
  byte   POGMA18 2074-2075
  byte   POGAP18 2076-2077
  byte   POGMY18 2078-2079
  byte   POGJU18 2080-2081
  byte   POGJL18 2082-2083
  byte   POGAU18 2084-2085
  byte   POGSE18 2086-2087
  byte   POGOC18 2088-2089
  byte   POGNO18 2090-2091
  byte   POGDE18 2092-2093
  byte   POEJA18 2094-2095
  byte   POEFE18 2096-2097
  byte   POEMA18 2098-2099
  byte   POEAP18 2100-2101
  byte   POEMY18 2102-2103
  byte   POEJU18 2104-2105
  byte   POEJL18 2106-2107
  byte   POEAU18 2108-2109
  byte   POESE18 2110-2111
  byte   POEOC18 2112-2113
  byte   POENO18 2114-2115
  byte   POEDE18 2116-2117
  byte   PNEJA18 2118-2119
  byte   PNEFE18 2120-2121
  byte   PNEMA18 2122-2123
  byte   PNEAP18 2124-2125
  byte   PNEMY18 2126-2127
  byte   PNEJU18 2128-2129
  byte   PNEJL18 2130-2131
  byte   PNEAU18 2132-2133
  byte   PNESE18 2134-2135
  byte   PNEOC18 2136-2137
  byte   PNENO18 2138-2139
  byte   PNEDE18 2140-2141
  byte   PRXJA18 2142-2143
  byte   PRXFE18 2144-2145
  byte   PRXMA18 2146-2147
  byte   PRXAP18 2148-2149
  byte   PRXMY18 2150-2151
  byte   PRXJU18 2152-2153
  byte   PRXJL18 2154-2155
  byte   PRXAU18 2156-2157
  byte   PRXSE18 2158-2159
  byte   PRXOC18 2160-2161
  byte   PRXNO18 2162-2163
  byte   PRXDE18 2164-2165
  byte   PRIJA18 2166-2167
  byte   PRIFE18 2168-2169
  byte   PRIMA18 2170-2171
  byte   PRIAP18 2172-2173
  byte   PRIMY18 2174-2175
  byte   PRIJU18 2176-2177
  byte   PRIJL18 2178-2179
  byte   PRIAU18 2180-2181
  byte   PRISE18 2182-2183
  byte   PRIOC18 2184-2185
  byte   PRINO18 2186-2187
  byte   PRIDE18 2188-2189
  byte   HPEJA18 2190-2191
  byte   HPEFE18 2192-2193
  byte   HPEMA18 2194-2195
  byte   HPEAP18 2196-2197
  byte   HPEMY18 2198-2199
  byte   HPEJU18 2200-2201
  byte   HPEJL18 2202-2203
  byte   HPEAU18 2204-2205
  byte   HPESE18 2206-2207
  byte   HPEOC18 2208-2209
  byte   HPENO18 2210-2211
  byte   HPEDE18 2212-2213
  byte   HPDJA18 2214-2215
  byte   HPDFE18 2216-2217
  byte   HPDMA18 2218-2219
  byte   HPDAP18 2220-2221
  byte   HPDMY18 2222-2223
  byte   HPDJU18 2224-2225
  byte   HPDJL18 2226-2227
  byte   HPDAU18 2228-2229
  byte   HPDSE18 2230-2231
  byte   HPDOC18 2232-2233
  byte   HPDNO18 2234-2235
  byte   HPDDE18 2236-2237
  byte   HPNJA18 2238-2239
  byte   HPNFE18 2240-2241
  byte   HPNMA18 2242-2243
  byte   HPNAP18 2244-2245
  byte   HPNMY18 2246-2247
  byte   HPNJU18 2248-2249
  byte   HPNJL18 2250-2251
  byte   HPNAU18 2252-2253
  byte   HPNSE18 2254-2255
  byte   HPNOC18 2256-2257
  byte   HPNNO18 2258-2259
  byte   HPNDE18 2260-2261
  byte   HPOJA18 2262-2263
  byte   HPOFE18 2264-2265
  byte   HPOMA18 2266-2267
  byte   HPOAP18 2268-2269
  byte   HPOMY18 2270-2271
  byte   HPOJU18 2272-2273
  byte   HPOJL18 2274-2275
  byte   HPOAU18 2276-2277
  byte   HPOSE18 2278-2279
  byte   HPOOC18 2280-2281
  byte   HPONO18 2282-2283
  byte   HPODE18 2284-2285
  byte   HPXJA18 2286-2287
  byte   HPXFE18 2288-2289
  byte   HPXMA18 2290-2291
  byte   HPXAP18 2292-2293
  byte   HPXMY18 2294-2295
  byte   HPXJU18 2296-2297
  byte   HPXJL18 2298-2299
  byte   HPXAU18 2300-2301
  byte   HPXSE18 2302-2303
  byte   HPXOC18 2304-2305
  byte   HPXNO18 2306-2307
  byte   HPXDE18 2308-2309
  byte   HPRJA18 2310-2311
  byte   HPRFE18 2312-2313
  byte   HPRMA18 2314-2315
  byte   HPRAP18 2316-2317
  byte   HPRMY18 2318-2319
  byte   HPRJU18 2320-2321
  byte   HPRJL18 2322-2323
  byte   HPRAU18 2324-2325
  byte   HPRSE18 2326-2327
  byte   HPROC18 2328-2329
  byte   HPRNO18 2330-2331
  byte   HPRDE18 2332-2333
  byte   INSJA18X 2334-2335
  byte   INSFE18X 2336-2337
  byte   INSMA18X 2338-2339
  byte   INSAP18X 2340-2341
  byte   INSMY18X 2342-2343
  byte   INSJU18X 2344-2345
  byte   INSJL18X 2346-2347
  byte   INSAU18X 2348-2349
  byte   INSSE18X 2350-2351
  byte   INSOC18X 2352-2353
  byte   INSNO18X 2354-2355
  byte   INSDE18X 2356-2357
  byte   PRVEV18 2358-2358
  byte   TRIEV18 2359-2359
  byte   MCREV18 2360-2360
  byte   MCDEV18 2361-2361
  byte   VAEV18 2362-2362
  byte   GVAEV18 2363-2363
  byte   GVBEV18 2364-2364
  byte   GVCEV18 2365-2365
  byte   UNINS18 2366-2366
  byte   INSCOV18 2367-2367
  byte   INSURC18 2368-2368
  byte   TRIST31X 2369-2370
  byte   TRIST42X 2371-2372
  byte   TRIST18X 2373-2374
  byte   TRIPR31X 2375-2376
  byte   TRIPR42X 2377-2378
  byte   TRIPR18X 2379-2380
  byte   TRIEX31X 2381-2382
  byte   TRIEX42X 2383-2384
  byte   TRIEX18X 2385-2386
  byte   TRILI31X 2387-2388
  byte   TRILI42X 2389-2390
  byte   TRILI18X 2391-2392
  byte   TRICH31X 2393-2394
  byte   TRICH42X 2395-2396
  byte   TRICH18X 2397-2398
  int    MCRPD31 2399-2401
  int    MCRPD42 2402-2404
  int    MCRPD18 2405-2407
  int    MCRPD31X 2408-2410
  int    MCRPD42X 2411-2413
  int    MCRPD18X 2414-2416
  int    MCRPB31 2417-2419
  int    MCRPB42 2420-2422
  int    MCRPB18 2423-2425
  int    MCRPHO31 2426-2428
  int    MCRPHO42 2429-2431
  int    MCRPHO18 2432-2434
  int    MCDHMO31 2435-2437
  int    MCDHMO42 2438-2440
  int    MCDHMO18 2441-2443
  int    MCDMC31 2444-2446
  int    MCDMC42 2447-2449
  int    MCDMC18 2450-2452
  int    PRVHMO31 2453-2455
  int    PRVHMO42 2456-2458
  int    PRVHMO18 2459-2461
  byte   FSAGT31 2462-2463
  int    HASFSA31 2464-2466
  int    PFSAMT31 2467-2470
  byte   PREVCOVR 2471-2472
  byte   MORECOVR 2473-2474
  byte   TRICR31X 2475-2476
  byte   TRICR42X 2477-2478
  byte   TRICR53X 2479-2480
  byte   TRICR18X 2481-2482
  byte   TRIAT31X 2483-2484
  byte   TRIAT42X 2485-2486
  byte   TRIAT53X 2487-2488
  byte   TRIAT18X 2489-2490
  byte   MCAID31 2491-2492
  byte   MCAID42 2493-2494
  byte   MCAID53 2495-2496
  byte   MCAID18 2497-2498
  byte   MCAID31X 2499-2500
  byte   MCAID42X 2501-2502
  byte   MCAID53X 2503-2504
  byte   MCAID18X 2505-2506
  byte   MCARE31 2507-2508
  byte   MCARE42 2509-2510
  byte   MCARE53 2511-2512
  byte   MCARE18 2513-2514
  byte   MCARE31X 2515-2516
  byte   MCARE42X 2517-2518
  byte   MCARE53X 2519-2520
  byte   MCARE18X 2521-2522
  byte   MCDAT31X 2523-2524
  byte   MCDAT42X 2525-2526
  byte   MCDAT53X 2527-2528
  byte   MCDAT18X 2529-2530
  byte   GOVTA31 2531-2532
  byte   GOVTA42 2533-2534
  byte   GOVTA53 2535-2536
  byte   GOVTA18 2537-2538
  byte   GOVAAT31 2539-2540
  byte   GOVAAT42 2541-2542
  byte   GOVAAT53 2543-2544
  byte   GOVAAT18 2545-2546
  byte   GOVTB31 2547-2548
  byte   GOVTB42 2549-2550
  byte   GOVTB53 2551-2552
  byte   GOVTB18 2553-2554
  byte   GOVBAT31 2555-2556
  byte   GOVBAT42 2557-2558
  byte   GOVBAT53 2559-2560
  byte   GOVBAT18 2561-2562
  byte   GOVTC31 2563-2564
  byte   GOVTC42 2565-2566
  byte   GOVTC53 2567-2568
  byte   GOVTC18 2569-2570
  byte   GOVCAT31 2571-2572
  byte   GOVCAT42 2573-2574
  byte   GOVCAT53 2575-2576
  byte   GOVCAT18 2577-2578
  byte   VAPROG31 2579-2580
  byte   VAPROG42 2581-2582
  byte   VAPROG53 2583-2584
  byte   VAPROG18 2585-2586
  byte   VAPRAT31 2587-2588
  byte   VAPRAT42 2589-2590
  byte   VAPRAT53 2591-2592
  byte   VAPRAT18 2593-2594
  byte   IHS31 2595-2596
  byte   IHS42 2597-2598
  byte   IHS53 2599-2600
  byte   IHS18 2601-2602
  byte   IHSAT31 2603-2604
  byte   IHSAT42 2605-2606
  byte   IHSAT53 2607-2608
  byte   IHSAT18 2609-2610
  byte   PRIDK31 2611-2612
  byte   PRIDK42 2613-2614
  byte   PRIDK53 2615-2616
  byte   PRIDK18 2617-2618
  byte   PRIEU31 2619-2620
  byte   PRIEU42 2621-2622
  byte   PRIEU53 2623-2624
  byte   PRIEU18 2625-2626
  byte   PRING31 2627-2628
  byte   PRING42 2629-2630
  byte   PRING53 2631-2632
  byte   PRING18 2633-2634
  byte   PRIOG31 2635-2636
  byte   PRIOG42 2637-2638
  byte   PRIOG53 2639-2640
  byte   PRIOG18 2641-2642
  byte   PRINEO31 2643-2644
  byte   PRINEO42 2645-2646
  byte   PRINEO53 2647-2648
  byte   PRINEO18 2649-2650
  byte   PRIEUO31 2651-2652
  byte   PRIEUO42 2653-2654
  byte   PRIEUO53 2655-2656
  byte   PRIEUO18 2657-2658
  byte   PRSTX31 2659-2660
  byte   PRSTX42 2661-2662
  byte   PRSTX53 2663-2664
  byte   PRSTX18 2665-2666
  byte   PRIV31 2667-2668
  byte   PRIV42 2669-2670
  byte   PRIV53 2671-2672
  byte   PRIV18 2673-2674
  byte   PRIVAT31 2675-2676
  byte   PRIVAT42 2677-2678
  byte   PRIVAT53 2679-2680
  byte   PRIVAT18 2681-2682
  byte   PUB31X 2683-2684
  byte   PUB42X 2685-2686
  byte   PUB53X 2687-2688
  byte   PUB18X 2689-2690
  byte   PUBAT31X 2691-2692
  byte   PUBAT42X 2693-2694
  byte   PUBAT53X 2695-2696
  byte   PUBAT18X 2697-2698
  byte   VERFLG31 2699-2700
  byte   VERFLG42 2701-2702
  byte   VERFLG18 2703-2704
  byte   INS31X 2705-2706
  byte   INS42X 2707-2708
  byte   INS53X 2709-2710
  byte   INS18X 2711-2712
  byte   INSAT31X 2713-2714
  byte   INSAT42X 2715-2716
  byte   INSAT53X 2717-2718
  byte   INSAT18X 2719-2720
  byte   DENTIN31 2721-2722
  byte   DENTIN42 2723-2724
  byte   DENTIN53 2725-2726
  byte   DNTINS31 2727-2728
  byte   DNTINS18 2729-2730
  byte   PMEDIN31 2731-2732
  byte   PMEDIN42 2733-2734
  byte   PMEDIN53 2735-2736
  byte   PMDINS31 2737-2738
  byte   PMDINS18 2739-2740
  byte   PROBPY42 2741-2742
  byte   CRFMPY42 2743-2744
  byte   PYUNBL42 2745-2746
  byte   PMEDUP31 2747-2748
  byte   PMEDUP42 2749-2750
  byte   PMEDUP53 2751-2752
  int    PMEDPY31 2753-2755
  int    PMEDPY42 2756-2758
  int    PMEDPY53 2759-2761
  long   TOTTCH18 2762-2768
  long   TOTEXP18 2769-2774
  long   TOTSLF18 2775-2780
  long   TOTMCR18 2781-2786
  long   TOTMCD18 2787-2792
  long   TOTPRV18 2793-2798
  long   TOTVA18 2799-2804
  long   TOTTRI18 2805-2810
  long   TOTOFD18 2811-2815
  long   TOTSTL18 2816-2820
  long   TOTWCP18 2821-2825
  long   TOTOPR18 2826-2831
  long   TOTOPU18 2832-2836
  long   TOTOSR18 2837-2842
  long   TOTPTR18 2843-2848
  long   TOTOTH18 2849-2854
  int    OBTOTV18 2855-2857
  long   OBVTCH18 2858-2864
  long   OBVEXP18 2865-2870
  long   OBVSLF18 2871-2876
  long   OBVMCR18 2877-2882
  long   OBVMCD18 2883-2887
  long   OBVPRV18 2888-2893
  long   OBVVA18 2894-2898
  long   OBVTRI18 2899-2903
  long   OBVOFD18 2904-2908
  int    OBVSTL18 2909-2912
  long   OBVWCP18 2913-2917
  long   OBVOPR18 2918-2922
  int    OBVOPU18 2923-2926
  long   OBVOSR18 2927-2931
  long   OBVPTR18 2932-2937
  long   OBVOTH18 2938-2942
  int    OBDRV18 2943-2945
  long   OBDTCH18 2946-2952
  long   OBDEXP18 2953-2958
  long   OBDSLF18 2959-2964
  long   OBDMCR18 2965-2970
  long   OBDMCD18 2971-2975
  long   OBDPRV18 2976-2981
  long   OBDVA18 2982-2986
  long   OBDTRI18 2987-2991
  long   OBDOFD18 2992-2996
  int    OBDSTL18 2997-3000
  long   OBDWCP18 3001-3005
  long   OBDOPR18 3006-3010
  int    OBDOPU18 3011-3014
  long   OBDOSR18 3015-3019
  long   OBDPTR18 3020-3025
  long   OBDOTH18 3026-3030
  int    OPTOTV18 3031-3033
  long   OPTTCH18 3034-3040
  long   OPTEXP18 3041-3046
  long   OPTSLF18 3047-3051
  long   OPTMCR18 3052-3056
  long   OPTMCD18 3057-3062
  long   OPTPRV18 3063-3068
  long   OPTVA18 3069-3073
  long   OPTTRI18 3074-3078
  int    OPTOFD18 3079-3082
  long   OPTSTL18 3083-3087
  long   OPTWCP18 3088-3092
  int    OPTOPR18 3093-3096
  int    OPTOPU18 3097-3100
  long   OPTOSR18 3101-3105
  long   OPTPTR18 3106-3111
  long   OPTOTH18 3112-3116
  long   OPFTCH18 3117-3123
  long   OPFEXP18 3124-3129
  long   OPFSLF18 3130-3134
  long   OPFMCR18 3135-3139
  long   OPFMCD18 3140-3145
  long   OPFPRV18 3146-3151
  long   OPFVA18 3152-3156
  long   OPFTRI18 3157-3161
  int    OPFOFD18 3162-3165
  long   OPFSTL18 3166-3170
  long   OPFWCP18 3171-3175
  int    OPFOPR18 3176-3179
  int    OPFOPU18 3180-3183
  long   OPFOSR18 3184-3188
  long   OPFPTR18 3189-3194
  long   OPFOTH18 3195-3199
  long   OPDEXP18 3200-3204
  long   OPDTCH18 3205-3209
  int    OPDSLF18 3210-3213
  long   OPDMCR18 3214-3218
  long   OPDMCD18 3219-3223
  long   OPDPRV18 3224-3228
  long   OPDVA18 3229-3233
  int    OPDTRI18 3234-3237
  byte   OPDOFD18 3238-3238
  int    OPDSTL18 3239-3241
  int    OPDWCP18 3242-3245
  int    OPDOPR18 3246-3249
  int    OPDOPU18 3250-3253
  long   OPDOSR18 3254-3258
  long   OPDPTR18 3259-3263
  long   OPDOTH18 3264-3268
  byte   OPDRV18 3269-3270
  long   OPVTCH18 3271-3277
  long   OPVEXP18 3278-3283
  long   OPVSLF18 3284-3288
  long   OPVMCR18 3289-3293
  long   OPVMCD18 3294-3299
  long   OPVPRV18 3300-3304
  long   OPVVA18 3305-3309
  int    OPVTRI18 3310-3313
  int    OPVOFD18 3314-3317
  int    OPVSTL18 3318-3321
  long   OPVWCP18 3322-3326
  int    OPVOPR18 3327-3330
  int    OPVOPU18 3331-3334
  long   OPVOSR18 3335-3339
  long   OPVPTR18 3340-3344
  long   OPVOTH18 3345-3349
  long   OPSEXP18 3350-3354
  long   OPSTCH18 3355-3359
  int    OPSSLF18 3360-3363
  long   OPSMCR18 3364-3368
  int    OPSMCD18 3369-3372
  long   OPSPRV18 3373-3377
  int    OPSVA18 3378-3381
  int    OPSTRI18 3382-3385
  byte   OPSOFD18 3386-3386
  int    OPSSTL18 3387-3389
  int    OPSWCP18 3390-3393
  int    OPSOPR18 3394-3397
  int    OPSOPU18 3398-3401
  long   OPSOSR18 3402-3406
  long   OPSPTR18 3407-3411
  long   OPSOTH18 3412-3416
  byte   ERTOT18 3417-3418
  long   ERTTCH18 3419-3424
  long   ERTEXP18 3425-3429
  int    ERTSLF18 3430-3433
  long   ERTMCR18 3434-3438
  long   ERTMCD18 3439-3443
  long   ERTPRV18 3444-3448
  int    ERTVA18 3449-3452
  int    ERTTRI18 3453-3456
  int    ERTOFD18 3457-3460
  long   ERTSTL18 3461-3465
  long   ERTWCP18 3466-3470
  int    ERTOPR18 3471-3474
  int    ERTOPU18 3475-3478
  int    ERTOSR18 3479-3482
  long   ERTPTR18 3483-3487
  long   ERTOTH18 3488-3492
  long   ERFTCH18 3493-3498
  long   ERFEXP18 3499-3503
  int    ERFSLF18 3504-3507
  long   ERFMCR18 3508-3512
  long   ERFMCD18 3513-3517
  long   ERFPRV18 3518-3522
  int    ERFVA18 3523-3526
  int    ERFTRI18 3527-3530
  int    ERFOFD18 3531-3534
  long   ERFSTL18 3535-3539
  long   ERFWCP18 3540-3544
  int    ERFOPR18 3545-3548
  int    ERFOPU18 3549-3552
  int    ERFOSR18 3553-3556
  long   ERFPTR18 3557-3561
  long   ERFOTH18 3562-3566
  long   ERDEXP18 3567-3571
  long   ERDTCH18 3572-3576
  int    ERDSLF18 3577-3580
  int    ERDMCR18 3581-3584
  int    ERDMCD18 3585-3588
  int    ERDPRV18 3589-3592
  int    ERDVA18 3593-3596
  int    ERDTRI18 3597-3600
  byte   ERDOFD18 3601-3601
  int    ERDSTL18 3602-3604
  int    ERDWCP18 3605-3608
  int    ERDOPR18 3609-3612
  int    ERDOPU18 3613-3615
  int    ERDOSR18 3616-3619
  int    ERDPTR18 3620-3623
  int    ERDOTH18 3624-3627
  byte   IPDIS18 3628-3629
  long   IPTEXP18 3630-3635
  long   IPTTCH18 3636-3642
  long   IPTSLF18 3643-3647
  long   IPTMCR18 3648-3653
  long   IPTMCD18 3654-3659
  long   IPTPRV18 3660-3665
  long   IPTVA18 3666-3671
  long   IPTTRI18 3672-3676
  long   IPTOFD18 3677-3681
  long   IPTSTL18 3682-3686
  long   IPTWCP18 3687-3691
  long   IPTOPR18 3692-3696
  long   IPTOPU18 3697-3701
  long   IPTOSR18 3702-3707
  long   IPTPTR18 3708-3713
  long   IPTOTH18 3714-3719
  long   IPFEXP18 3720-3725
  long   IPFTCH18 3726-3732
  long   IPFSLF18 3733-3737
  long   IPFMCR18 3738-3743
  long   IPFMCD18 3744-3749
  long   IPFPRV18 3750-3755
  long   IPFVA18 3756-3761
  long   IPFTRI18 3762-3766
  long   IPFOFD18 3767-3771
  long   IPFSTL18 3772-3776
  long   IPFWCP18 3777-3781
  long   IPFOPR18 3782-3786
  long   IPFOPU18 3787-3791
  long   IPFOSR18 3792-3797
  long   IPFPTR18 3798-3803
  long   IPFOTH18 3804-3809
  long   IPDEXP18 3810-3814
  long   IPDTCH18 3815-3820
  int    IPDSLF18 3821-3824
  long   IPDMCR18 3825-3829
  long   IPDMCD18 3830-3834
  long   IPDPRV18 3835-3839
  long   IPDVA18 3840-3844
  int    IPDTRI18 3845-3848
  byte   IPDOFD18 3849-3849
  int    IPDSTL18 3850-3853
  int    IPDWCP18 3854-3857
  int    IPDOPR18 3858-3861
  int    IPDOPU18 3862-3865
  long   IPDOSR18 3866-3870
  long   IPDPTR18 3871-3875
  long   IPDOTH18 3876-3880
  int    IPNGTD18 3881-3883
  byte   DVTOT18 3884-3885
  long   DVTTCH18 3886-3890
  long   DVTEXP18 3891-3895
  long   DVTSLF18 3896-3900
  int    DVTMCR18 3901-3904
  long   DVTMCD18 3905-3909
  long   DVTPRV18 3910-3914
  int    DVTVA18 3915-3918
  int    DVTTRI18 3919-3922
  int    DVTOFD18 3923-3926
  int    DVTSTL18 3927-3930
  int    DVTWCP18 3931-3933
  int    DVTOPR18 3934-3937
  int    DVTOPU18 3938-3941
  int    DVTOSR18 3942-3945
  long   DVTPTR18 3946-3950
  int    DVTOTH18 3951-3954
  int    HHTOTD18 3955-3957
  int    HHAGD18 3958-3960
  long   HHATCH18 3961-3966
  long   HHAEXP18 3967-3972
  long   HHASLF18 3973-3977
  long   HHAMCR18 3978-3983
  long   HHAMCD18 3984-3989
  long   HHAPRV18 3990-3994
  long   HHAVA18 3995-3999
  byte   HHATRI18 4000-4000
  int    HHAOFD18 4001-4004
  long   HHASTL18 4005-4009
  byte   HHAWCP18 4010-4010
  int    HHAOPR18 4011-4014
  int    HHAOPU18 4015-4018
  int    HHAOSR18 4019-4022
  long   HHAPTR18 4023-4027
  long   HHAOTH18 4028-4032
  int    HHINDD18 4033-4035
  long   HHNTCH18 4036-4041
  long   HHNEXP18 4042-4047
  long   HHNSLF18 4048-4053
  long   HHNMCD18 4054-4058
  int    HHNMCR18 4059-4062
  int    HHNPRV18 4063-4066
  long   HHNVA18 4067-4071
  byte   HHNTRI18 4072-4073
  byte   HHNOFD18 4074-4074
  int    HHNSTL18 4075-4077
  byte   HHNWCP18 4078-4078
  int    HHNOPR18 4079-4081
  byte   HHNOPU18 4082-4082
  long   HHNOSR18 4083-4087
  int    HHNPTR18 4088-4091
  long   HHNOTH18 4092-4096
  int    HHINFD18 4097-4099
  long   VISEXP18 4100-4104
  long   VISTCH18 4105-4109
  int    VISSLF18 4110-4113
  int    VISMCR18 4114-4117
  long   VISMCD18 4118-4122
  int    VISPRV18 4123-4126
  int    VISVA18 4127-4129
  int    VISTRI18 4130-4132
  int    VISOFD18 4133-4135
  int    VISSTL18 4136-4138
  int    VISWCP18 4139-4141
  int    VISOPR18 4142-4145
  int    VISOPU18 4146-4148
  int    VISOSR18 4149-4152
  int    VISPTR18 4153-4156
  int    VISOTH18 4157-4160
  long   OTHTCH18 4161-4165
  long   OTHEXP18 4166-4170
  long   OTHSLF18 4171-4175
  long   OTHMCR18 4176-4180
  long   OTHMCD18 4181-4185
  long   OTHPRV18 4186-4190
  int    OTHVA18 4191-4194
  long   OTHTRI18 4195-4199
  long   OTHOFD18 4200-4204
  int    OTHSTL18 4205-4208
  long   OTHWCP18 4209-4213
  int    OTHOPR18 4214-4217
  int    OTHOPU18 4218-4221
  int    OTHOSR18 4222-4225
  long   OTHPTR18 4226-4230
  long   OTHOTH18 4231-4235
  int    RXTOT18 4236-4238
  long   RXEXP18 4239-4244
  long   RXSLF18 4245-4249
  long   RXMCR18 4250-4255
  long   RXMCD18 4256-4261
  long   RXPRV18 4262-4267
  long   RXVA18 4268-4272
  long   RXTRI18 4273-4277
  long   RXOFD18 4278-4282
  long   RXSTL18 4283-4287
  int    RXWCP18 4288-4291
  long   RXOPR18 4292-4297
  long   RXOPU18 4298-4302
  long   RXOSR18 4303-4308
  long   RXPTR18 4309-4314
  long   RXOTH18 4315-4320
  double PERWT18F 4321-4332
  double FAMWT18F 4333-4344
  double FAMWT18C 4345-4356
  double SAQWT18F 4357-4369
  double DIABW18F 4370-4381
  double VSAQW18F 4382-4393
  int    VARSTR 4394-4397
  byte   VARPSU 4398-4398
using H209.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "PANEL # + ENCRYPTED DU IDENTIFIER";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID18 "FAMILY ID (STUDENT MERGED IN) - 12/31/18";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR18 "RU LETTER AS OF 12/31/18";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE18 "RU SIZE AS OF 12/31/18";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS18 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/18";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE18 "RU SIZE INCLUDING STUDENT AS OF 12/31/18";
label variable FMRS1231 "MVAPCUN53 ER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION18 "CENSUS REGION AS OF 12/31/18";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS18 "REFERENCE PERSON AS OF 12/31/18";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP18 "1ST RESPONDENT INDICATOR AS OF 12/31/18";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY18 "WAS RESPONDENT A PROXY AS OF 12/31/18";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFM18 "2018 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY18 "2018 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP18 "INSCOPE - R5/3 START THROUGH 12/31/18";
label variable INSC1231 "INSCOPE STATUS ON 12/31/18";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2018";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND18 "ELIGIBILITY STATUS AS OF 12/31/18";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE18X "AGE AS OF 12/31/18 (EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEV1X "RACE (EDITED/IMPUTED)";
label variable RACEV2X "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPNCAT "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY18X "MARITAL STATUS-12/31/18 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID18 "SPOUSE ID - 12/31/18";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN18 "MARITAL STATUS W/SPOUSE PRESENT-12/31/18";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU18X "STUDENT STATUS IF AGES 17-23 - 12/31/18";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable REFRL31X "RELATION TO REF PERS- R3/1 (EDIT/IMP)";
label variable REFRL42X "RELATION TO REF PERS- R4/2 (EDIT/IMP)";
label variable REFRL53X "RELATION TO REF PERS- R5/3 (EDIT/IMP)";
label variable REFRL18X "RELATION TO REF PERS-12/31/18 (EDIT/IMP)";
label variable OTHLANG "IN FAMILY WITH SOMEONE SPKNG OTHER LANG";
label variable LANGSPK "LANGUAGE SPOKEN AT HOME OTHER THAN ENGL";
label variable HWELLSPE "HOW WELL PERS SPKS ENG-FAMILY OTH LANG";
label variable OTHLGSPK "SPEAK OTHER LANGUAGE AT HOME";
label variable WHTLGSPK "WHAT LANGUAGE SPOKEN OTHER THAN ENGLISH";
label variable HWELLSPK "HOW WELL PERSON SPEAKS ENGLISH";
label variable BORNUSA "PERSON BORN IN THE US";
label variable YRSINUS "YEARS PERSON LIVED IN THE US";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable OHRTTYPE "TYPE OF OTHER HEART DISEASE (>17)";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable CACERVIX "CANCER DIAGNOSED - CERVICAL (>17)";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (NON-HODGKIN S) (>17)";
label variable CAMELANO "CANCER DIAGNOSED - SKIN MELANOMA (>17)";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable CAUTERUS "CANCER DIAGNOSED - UTERINE (>17)";
label variable DIABDX_M18 "DIABETES DIAGNOSIS";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31_M18 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA - RD 3/1";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS- RD 3/1";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASACUT31 "USED ACUTE PRESCRIBED INHALER LAST 3 MOS - RD 3/1";
label variable ASMRCN31 "USED >3 ACUTE CANSTRS PRESCRIBED INH LAST 3 MOS - RD 3/1";
label variable ASPREV31 "EVER USED PREV DAILY ASTHMA MEDS - RD 3/1";
label variable ASDALY31 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 3/1";
label variable ASPKFL31 "HAVE PEAK FLOW METER AT HOME - RD 3/1";
label variable ASEVFL31 "EVER USED PEAK FLOW METER - RD 3/1";
label variable ASWNFL31 "WHEN LAST USED PEAK FLOW METER - RD 3/1";
label variable ADHDADDX "ADHD/ADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable DFHEAR42 "SERIOUS DIFFICULTY HEARING-RD 4/2";
label variable DFSEE42 "SERIOUS DIFFICULTY SEE W/GLASSES-RD 4/2";
label variable DFCOG42 "SERIOUS COGNITIVE DIFFICULTIES-RD 4/2";
label variable DFWLKC42 "SERIOUS DIFCULTY WLK/CLIMB STAIRS-RD 4/2";
label variable DFDRSB42 "DIFFICULTY DRESSING/BATHING-RD 4/2";
label variable DFERND42 "DIFFICULTY DOING ERRANDS ALONE-RD 4/2";
label variable ANYLMI18 "ANY LIMITATION IN P22R3,4/P23R1,2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable OFTSMK53 "HOW OFTN SMOKE CIGARETTES (>17) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADSEX42 "SAQ: SURVEY GENDER";
label variable ADAGE42 "SAQ: SURVEY AGE";
label variable ADPROX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL VR-12";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES VR-12";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS VR-12";
label variable ADACLS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS VR-12";
label variable ADWKLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS VR-12";
label variable ADEMLS42 "SAQ 4WKS: ACCMP LESS B/C MNT PRBS VR-12";
label variable ADMWCF42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS VR-12";
label variable ADPAIN42 "SAQ 4WKS: PAIN LIMITS NORMAL WORK VR-12";
label variable ADPCFL42 "SAQ 4WKS: FELT CALM/PEACEFUL VR-12";
label variable ADENGY42 "SAQ 4WKS: HAD A LOT OF ENERGY VR-12";
label variable ADPRST42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR VR-12";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV VR-12";
label variable VPCS42 "SAQ:PHY COMPONENT SUMMRY VR-12 IMPUTED";
label variable VMCS42 "SAQ:MNT COMPONENT SUMMRY VR-12 IMPUTED";
label variable VRFLAG42 "SAQ: VPCS42/VMCS42 IMPUTATION FLAG VR-12";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVERYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADBRTC42 "SAQ 12 MTHS: BIRTH CONTROL COUNSELING";
label variable ADMDVT42 "SAQ: LAST TIME DR VISIT";
label variable ADFLST42 "SAQ 12 MTHS: FLU VACCINATION";
label variable ADWGHD42 "SAQ 12 MTHS: WEIGHED BY PROFESSIONAL";
label variable ADBMI42 "SAQ: ADULT BODY MASS INDEX (>17)-RD 4/2";
label variable ADWTAD42 "SAQ 12 MTHS: WEIGHT MANAGEMENT ADVICE";
label variable ADKALC42 "SAQ 12 MTHS: ASKED ALCOHOL CONSUMPTION";
label variable ADRNK542 "SAQ 12 MTHS: HAD 5+ DRINKS PER DAY";
label variable ADRNK442 "SAQ 12 MTHS: HAD 4+ DRINKS PER DAY";
label variable ADSTAL42 "SAQ: 12 MTHS: ADVISED TO STOP ALCOHOL";
label variable ADTBAC42 "SAQ 12 MTHS: DID DR ASK ABOUT TOBACCO";
label variable ADOFTB42 "SAQ 12 MTHS: HOW OFTEN USE TOBACCO";
label variable ADQTTB42 "SAQ 12 MTHS: DID DR ADVISE QUIT TOBACCO";
label variable ADQTMD42 "SAQ 12 MTHS: DR ADVS MEDS TO QUIT TOBAC";
label variable ADQTHP42 "SAQ 12 MTHS: DR ADVS OTH WAY QUIT TOBAC";
label variable ADMOOD42 "SAQ 12 MTHS: DR ASK ANXIOUS/DEPRSSED";
label variable ADBPCK42 "SAQ 24 MTHS: DR CHECK BLOOD PRESSURE";
label variable ADCHLC42 "SAQ 5 YRS: DR CHECK CHOLESTEROL";
label variable ADPNEU42 "SAQ: EVER HAD PNEUMONIA SHOT";
label variable ADSHNG42 "SAQ: EVER HAD SHINGLES VACCINE";
label variable ADNOAP42 "SAQ: CAN T TAKE ASPRIN FOR MED REASON";
label variable ADDSCU42 "SAQ: DISCUSS ASPIRIN PREVENTIVE USE";
label variable ADCOLN42 "SAQ: HAD COLON CANCER/COLON REMOVED";
label variable ADCLNS42 "SAQ 10 YRS: HAD COLONOSCOPY";
label variable ADSGMD42 "SAQ 5 YRS: HAD SIGMOIDOSCOPY";
label variable ADBLDS42 "SAQ 12 MTHS: AT HOME BLOOD STOOL TEST";
label variable ADPROS42 "SAQ: HAD PROSTATE CANCER";
label variable ADPSAG42 "SAQ: AGE LAST PSA TEST";
label variable ADUTRM42 "SAQ: HAD HYSTRCTMY/CRVCL CANCER";
label variable ADPAP42 "SAQ 5 YRS: HAD PAP SMEAR TEST";
label variable ADPAPG42 "SAQ: AGE AT LAST PAP SMEAR TEST";
label variable ADOSTP42 "SAQ: DX WITH OSTEOPOROSIS";
label variable ADBNDN42 "SAQ: BONE DENSITY SCAN";
label variable ADBRST42 "SAQ: HAVE BRST CANCER\BRST REMOVED";
label variable ADMMGR42 "SAQ 2 YRS: HAD MAMMOGRAM";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable VSAQELIG "ELIGIBILITY STATUS FOR VSAQ";
label variable VACTDY53 "VSAQ: EVER SERVED ON ACTIVE DUTY";
label variable VAPRHT53 "VSAQ: PURPLE HEART RECIPIENT";
label variable VACOPD53 "VSAQ: DIAGNOSED WITH COPD";
label variable VADERM53 "VSAQ: DIAGNOSED WITH DERMATOL CONDITIONS";
label variable VAGERD53 "VSAQ: DIAGNOSED WITH GERD";
label variable VAHRLS53 "VSAQ: DIAGNOSED WITH HEARING LOSS";
label variable VABACK53 "VSAQ: DIAGNOSED WITH BACK PAIN";
label variable VAJTPN53 "VSAQ: EVER DIAGNOSED WITH JOINT PAIN";
label variable VARTHR53 "VSAQ: EVER DIAGNOSED WITH OSTEOARTHRITIS";
label variable VAGOUT53 "VSAQ: EVER DIAGNOSED WITH GOUT";
label variable VANECK53 "VSAQ: EVER DIAGNOSED WITH NECK PAIN";
label variable VATMD53 "VSAQ: EVER DIAGNOSED WITH TMD";
label variable VAPTSD53 "VSAQ: EVER DIAGNOSED WITH PTSD";
label variable VALCOH53 "VSAQ: EVER DIAGNOSED WITH ALCOHOL ABUSE";
label variable VABIPL53 "VSAQ: EVR DIAGNOSED WITH BIPOLAR DISORDER";
label variable VADEPR53 "VSAQ: EVER DIAGNOSED WITH DEPRESSION";
label variable VAMOOD53 "VSAQ: EVER DIAGNOSED WITH MOOD DISORDER";
label variable VAPROS53 "VSAQ: RECEIVE PROSTHESIS";
label variable VARHAB53 "VSAQ: RECEIVE REHABILITATION SERVICES";
label variable VAMNHC53 "VSAQ: RECEIVE INDIVIDL MENTAL HLTH CARE";
label variable VAGCNS53 "VSAQ: RECEIVE MENTAL HLTH GRP COUNSELING";
label variable VARXMD53 "VSAQ: RECEIVE PRESCRIPTION MEDICATIONS";
label variable VACRGV53 "VSAQ: RECEIVE CAREGIVER SUPPORT";
label variable VAMOBL53 "VSAQ: RECEIVE ASSISTIVE MOBILITY DEVICE";
label variable VACOST53 "VSAQ: COST OF CARE";
label variable VARECM53 "VSAQ: RECOMMENDATION OF ANOTHER DOCTOR";
label variable VAREP53 "VSAQ:REPUTATION OF DOCTOR PROVIDING CARE";
label variable VAWAIT53 "VSAQ: SHORT WAIT TIME";
label variable VALOCT53 "VSAQ: LOCATION OF DOCTOR S PRACTICE";
label variable VANTWK53 "VSAQ: IN NETWORK PROVIDER";
label variable VANEED53 "VSAQ: UNDERSTANDS NEEDS OF VETERANS";
label variable VAOUT53 "VSAQ 12 MOS: VISIT PROVIDER OUTSIDE VA";
label variable VAPAST53 "VSAQ 12MOS:NON-VA PRVDR KNW PST HLTH PROBLEMS";
label variable VACOMP53 "VSAQ 12MOS: NON-VA PRVDR HLTH INFO COMPLETE";
label variable VAMREC53 "VSAQ 12MOS: ASK NON-VA PRVDR FOR MED RECORDS";
label variable VAGTRC53 "VSAQ 12MOS: NON-VA PRVDR GET MED RECORDS";
label variable VACARC53 "VSAQ 12MOS: NON-VA PRVDR AWARE VA SRVCS";
label variable VAPROB53 "VSAQ: PROB NON-VA PRVDR NOT AWAR VA SVCS";
label variable VACARE53 "VSAQ 12MOS: RECVD CARE FROM VA PROVIDER";
label variable VAPACT53 "VSAQ 12MOS: VISIT PACT OR PCP";
label variable VAPCPR53 "VSAQ 12MOS: VA PCP/PACT KNW PST HLTH PROBLEMS";
label variable VAPROV53 "VSAQ 12MOS: SEE VA PROV OTH THN PCP/PACT";
label variable VAPCOT53 "VSAQ 12MOS: VA PCP KNW RSLT OTH VA PRVDR";
label variable VAPCCO53 "VSAQ 12MOS: VA PCP/PACT HLTH INFO COMPLETE";
label variable VAPCRC53 "VSAQ 12MOS: ASK VA PCP/PACT FOR MED RECORDS";
label variable VAPCSN53 "VSAQ 12MOS: VA PCP/PACT GET MED RECORDS";
label variable VAPCRF53 "VSAQ 12MOS: NEED RFRL TO NON-VA PRVDR";
label variable VAPCSO53 "VSAQ 12MOS: GET RFRL TO NON-VA PRVDR";
label variable VAPCOU53 "VSAQ 12MOS:VA PCP/PACT AWARE NON-VA SVCS";
label variable VAPCUN53 "VSAQ: VA PCP/PACT UNAWARE NON-VA SVCS";
label variable VASPCL53 "VSAQ 12MOS: RECEIVE CARE FROM VA SPECLST";
label variable VASPMH53 "VSAQ 12MOS: VA SPCLST HAD MED HISTORY";
label variable VASPOU53 "VSAQ 12MOS: VA SPCLST AWARE NON-VA SVCS";
label variable VASPUN53 "VSAQ 12MOS: VA SPLST UNAWARE NON-VA SVCS";
label variable VACMPM53 "VSAQ: DATE COMPLETED - MONTH";
label variable VACMPY53 "VSAQ: DATE COMPLETED - YEAR";
label variable VAPROX53 "VSAQ: RELATIONSHIP OF PROXY TO VETERAN";
label variable DCSELIG "DCS: ELIGIBILITY STATUS FOR DCS";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2018";
label variable DSFT1953 "DCS: HAD FEET CHECKED DURING 2019";
label variable DSFT1853 "DCS: HAD FEET CHECKED DURING 2018";
label variable DSFT1753 "DCS: HAD FEET CHECKED DURING 2017";
label variable DSFB1753 "DCS: HAD FEET CHECKED BEFORE 2017";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1953 "DCS: DILATED EYE EXAM IN 2019";
label variable DSEY1853 "DCS: DILATED EYE EXAM IN 2018";
label variable DSEY1753 "DCS: DILATED EYE EXAM IN 2017";
label variable DSEB1753 "DCS: DILATED EYE EXAM BEFORE 2017";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1953 "DCS: BLOOD CHOLESTEROL CHECKED IN 2019";
label variable DSCH1853 "DCS: BLOOD CHOLESTEROL CHECKED IN 2018";
label variable DSCH1753 "DCS: BLOOD CHOLESTEROL CHECKED IN 2017";
label variable DSCB1753 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2017";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1953 "DCS: GOT FLU VACCINATION IN 2019";
label variable DSFL1853 "DCS: GOT FLU VACCINATION IN 2018";
label variable DSFL1753 "DCS: GOT FLU VACCINATION IN 2017";
label variable DSVB1753 "DCS: GOT FLU VACCINATION BEFORE 2017";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/ PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK18 "# DAYS MISSED WORK DUE TO ILL/INJ 2018";
label variable OTHDYS18 "MISS ANY WORK DAY TO CARE FOR OTH 2018";
label variable OTHNDD18 "# DAY MISSED WORK TO CARE FOR OTH 2018";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable HAVEUS42 "DOES PERSON HAVE USC PROVIDER-R4/2";
label variable PRACTP42 "PROVIDER OWN/GROUP PRACTICE-R4/2";
label variable YNOUSC42_M18 "MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable PROVTY42_M18 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable TMTKUS42 "HOW LONG IT TAKES GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "IS PROVIDER MALE OR FEMALE-R4/2";
label variable PHNREG42 "HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable DECIDE42 "PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable PRVSPK42 "PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable DLAYCA42 "DELAY MED CARE FOR COST-R4/2";
label variable AFRDCA42 "COULD NOT AFFORD MED CARE-R4/2";
label variable DLAYDN42 "DELAY GETTING DENTAL FOR COST-R4/2";
label variable AFRDDN42 "COULD NOT AFFORD DENTAL CARE-R4/2";
label variable DLAYPM42 "DELAY GETTING PMED FOR COST-R4/2";
label variable AFRDPM42 "COULD NOT AFFORD PMED CARE-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/18";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD 3/1 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD 4/2 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD 5/3 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCATION";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCATION";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCATION";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable EMPST31H "EMPLOYMENT STATUS RD 3/1 (IMP)";
label variable EMPST42H "EMPLOYMENT STATUS RD 4/2 (IMP)";
label variable EMPST53H "EMPLOYMENT STATUS RD 5/3 (IMP)";
label variable SLFCM31H "SELF-EMPLOYED AT RD 3/1 CMJ (IMP)";
label variable SLFCM42H "SELF-EMPLOYED AT RD 4/2 CMJ (IMP)";
label variable SLFCM53H "SELF-EMPLOYED AT RD 5/3 CMJ (IMP)";
label variable NMEMP31H "NUMBER OF EMPLOYEES AT RD 3/1 CMJ (IMP)";
label variable NMEMP42H "NUMBER OF EMPLOYEES AT RD 4/2 CMJ (IMP)";
label variable NMEMP53H "NUMBER OF EMPLOYEES AT RD 5/3 CMJ (IMP)";
label variable MORE31H "RD 3/1 CMJ FIRM MORE THAN 1 LOCATION (IMP)";
label variable MORE42H "RD 4/2 CMJ FIRM MORE THAN 1 LOCATION (IMP)";
label variable MORE53H "RD 5/3 CMJ FIRM MORE THAN 1 LOCATION (IMP)";
label variable INDCT31H "INDUSTRY GROUP RD 3/1 CMJ (IMP)";
label variable INDCT42H "INDUSTRY GROUP RD 4/2 CMJ (IMP)";
label variable INDCT53H "INDUSTRY GROUP RD 5/3 CMJ (IMP)";
label variable OCCCT31H "OCCUPATION GROUP RD 3/1 CMJ (IMP)";
label variable OCCCT42H "OCCUPATION GROUP RD 4/2 CMJ (IMP)";
label variable OCCCT53H "OCCUPATION GROUP RD 5/3 CMJ (IMP)";
label variable HOUR31H "HOURS PER WEEK AT RD 3/1 CMJ (IMP)";
label variable HOUR42H "HOURS PER WEEK AT RD 4/2 CMJ (IMP)";
label variable HOUR53H "HOURS PER WEEK AT RD 5/3 CMJ (IMP)";
label variable JBORG31H "PRV, ST-LC GOV, FED GOV RD 3/1 CMJ (IMP)";
label variable JBORG42H "PRV, ST-LC GOV, FED GOV RD 4/2 CMJ (IMP)";
label variable JBORG53H "PRV, ST-LC GOV, FED GOV RD 5/3 CMJ (IMP)";
label variable UNION31H "UNION STATUS AT RD 3/1 CMJ (IMP)";
label variable UNION42H "UNION STATUS AT RD 4/2 CMJ (IMP)";
label variable UNION53H "UNION STATUS AT RD 5/3 CMJ (IMP)";
label variable BSNTY31H "SOL PROP, PRTNR, CORP, RD 3/1 CMJ (IMP)";
label variable BSNTY42H "SOL PROP, PRTNR, CORP, RD 4/2 CMJ (IMP)";
label variable BSNTY53H "SOL PROP, PRTNR, CORP, RD 5/3 CMJ (IMP)";
label variable HRWG31H "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42H "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53H "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable CMJHLD31 "HLTH INSUR HELD FROM RD 3/1 CMJ (PRPL)";
label variable CMJHLD42 "HLTH INSUR HELD FROM RD 4/2 CMJ (PRPL)";
label variable CMJHLD53 "HLTH INSUR HELD FROM RD 5/3 CMJ (PRPL)";
label variable OFFER31H "HEALTH INSUR OFFERED BY RD 3/1 CMJ (IMP)";
label variable OFFER42H "HEALTH INSUR OFFERED BY RD 4/2 CMJ (IMP)";
label variable OFFER53H "HEALTH INSUR OFFERED BY RD 5/3 CMJ (IMP)";
label variable OFEMP31H "EMP OFFERS HEALTH INS RD 3/1 CMJ (IMP)";
label variable OFEMP42H "EMP OFFERS HEALTH INS RD 4/2 CMJ (IMP)";
label variable OFEMP53H "EMP OFFERS HEALTH INS RD 5/3 CMJ (IMP)";
label variable PYVAC31H "PAID VACATION AT RD 3/1 CMJ (IMP)";
label variable PYVAC42H "PAID VACATION AT RD 4/2 CMJ (IMP)";
label variable PYVAC53H "PAID VACATION AT RD 5/3 CMJ (IMP)";
label variable SCPAY31H "PAID SICK LEAVE AT RD 3/1 CMJ (IMP)";
label variable SCPAY42H "PAID SICK LEAVE AT RD 4/2 CMJ (IMP)";
label variable SCPAY53H "PAID SICK LEAVE AT RD 5/3 CMJ (IMP)";
label variable PAYDR31H "PAID LEAVE TO VISIT DR RD 3/1 CMJ (IMP)";
label variable PAYDR42H "PAID LEAVE TO VISIT DR RD 4/2 CMJ (IMP)";
label variable PAYDR53H "PAID LEAVE TO VISIT DR RD 5/3 CMJ (IMP)";
label variable RTPLN31H "PENSION PLAN AT RD 3/1 CMJ (IMP)";
label variable RTPLN42H "PENSION PLAN AT RD 4/2 CMJ (IMP)";
label variable RTPLN53H "PENSION PLAN AT RD 5/3 CMJ (IMP)";
label variable FILEDR18 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL18 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT18 "PERSON S FILING STATUS";
label variable FILER18 "PRIMARY OR SECONDARY FILER";
label variable JTINRU18 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID18 "PID OF SECONDARY FILER";
label variable TAXFRM18 "TAX FORM PERSON WILL FILE";
label variable FOODST18 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN18 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL18 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP18X "PERSON S TOTAL INCOME";
label variable FAMINC18 "FAMILY S TOTAL INCOME";
label variable POVCAT18 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV18 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP18X "PERSON S WAGE INCOME";
label variable WAGIMP18 "WAGE IMPUTATION FLAG";
label variable BUSNP18X "PERSON S BUSINESS INCOME";
label variable BUSIMP18 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP18X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP18 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP18X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP18 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP18X "PERSON S INTEREST INCOME";
label variable INTIMP18 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP18X "PERSON S DIVIDEND INCOME";
label variable DIVIMP18 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP18X "PERSON S SALES INCOME";
label variable SALIMP18 "SALES INCOME IMPUTATION FLAG";
label variable PENSP18X "PERSON S PENSION INCOME";
label variable PENIMP18 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP18X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP18 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP18X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP18 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP18X "PERSON S VETERAN S INCOME";
label variable VETIMP18 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP18X "PERSON S IRA INCOME";
label variable IRAIMP18 "IRA INCOME IMPUTATION FLAG";
label variable ALIMP18X "PERSON S ALIMONY INCOME";
label variable ALIIMP18 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP18X "PERSON S CHILD SUPPORT";
label variable CHLIMP18 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP18X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP18 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP18X "PERSON S SSI";
label variable SSIIMP18 "SSI IMPUTATION FLAG";
label variable PUBP18X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP18 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP18X "PERSON S OTHER INCOME";
label variable OTHIMP18 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA18X "COVERED BY TRICARE/CHAMPVA IN JAN18 (ED)";
label variable TRIFE18X "COVERED BY TRICARE/CHAMPVA IN FEB18 (ED)";
label variable TRIMA18X "COVERED BY TRICARE/CHAMPVA IN MAR18 (ED)";
label variable TRIAP18X "COVERED BY TRICARE/CHAMPVA IN APR18(ED)";
label variable TRIMY18X "COVERED BY TRICARE/CHAMPVA IN MAY18 (ED)";
label variable TRIJU18X "COVERED BY TRICARE/CHAMPVA IN JUN18 (ED)";
label variable TRIJL18X "COVERED BY TRICARE/CHAMPVA IN JUL18 (ED)";
label variable TRIAU18X "COVERED BY TRICARE/CHAMPVA IN AUG18 (ED)";
label variable TRISE18X "COVERED BY TRICARE/CHAMPVA IN SEP18 (ED)";
label variable TRIOC18X "COVERED BY TRICARE/CHAMPVA IN OCT18 (ED)";
label variable TRINO18X "COVERED BY TRICARE/CHAMPVA IN NOV18 (ED)";
label variable TRIDE18X "COVERED BY TRICARE/CHAMPVA IN DEC18 (ED)";
label variable MCRJA18 "COVERED BY MEDICARE IN JAN18";
label variable MCRFE18 "COVERED BY MEDICARE IN FEB18";
label variable MCRMA18 "COVERED BY MEDICARE IN MAR18";
label variable MCRAP18 "COVERED BY MEDICARE IN APR18";
label variable MCRMY18 "COVERED BY MEDICARE IN MAY18";
label variable MCRJU18 "COVERED BY MEDICARE IN JUN18";
label variable MCRJL18 "COVERED BY MEDICARE IN JUL18";
label variable MCRAU18 "COVERED BY MEDICARE IN AUG18";
label variable MCRSE18 "COVERED BY MEDICARE IN SEP18";
label variable MCROC18 "COVERED BY MEDICARE IN OCT18";
label variable MCRNO18 "COVERED BY MEDICARE IN NOV18";
label variable MCRDE18 "COVERED BY MEDICARE IN DEC18";
label variable MCRJA18X "COVERED BY MEDICARE IN JAN18 (ED)";
label variable MCRFE18X "COVERED BY MEDICARE IN FEB18 (ED)";
label variable MCRMA18X "COVERED BY MEDICARE IN MAR18 (ED)";
label variable MCRAP18X "COVERED BY MEDICARE IN APR18 (ED)";
label variable MCRMY18X "COVERED BY MEDICARE IN MAY18 (ED)";
label variable MCRJU18X "COVERED BY MEDICARE IN JUN18 (ED)";
label variable MCRJL18X "COVERED BY MEDICARE IN JUL18 (ED)";
label variable MCRAU18X "COVERED BY MEDICARE IN AUG18 (ED)";
label variable MCRSE18X "COVERED BY MEDICARE IN SEP18 (ED)";
label variable MCROC18X "COVERED BY MEDICARE IN OCT18 (ED)";
label variable MCRNO18X "COVERED BY MEDICARE IN NOV18 (ED)";
label variable MCRDE18X "COVERED BY MEDICARE IN DEC18 (ED)";
label variable MCDJA18 "COV BY MEDICAID OR SCHIP IN JAN18";
label variable MCDFE18 "COV BY MEDICAID OR SCHIP IN FEB18";
label variable MCDMA18 "COV BY MEDICAID OR SCHIP IN MAR18";
label variable MCDAP18 "COV BY MEDICAID OR SCHIP IN APR18";
label variable MCDMY18 "COV BY MEDICAID OR SCHIP IN MAY18";
label variable MCDJU18 "COV BY MEDICAID OR SCHIP IN JUN18";
label variable MCDJL18 "COV BY MEDICAID OR SCHIP IN JUL18";
label variable MCDAU18 "COV BY MEDICAID OR SCHIP IN AUG18";
label variable MCDSE18 "COV BY MEDICAID OR SCHIP IN SEP18";
label variable MCDOC18 "COV BY MEDICAID OR SCHIP IN OCT18";
label variable MCDNO18 "COV BY MEDICAID OR SCHIP IN NOV18";
label variable MCDDE18 "COV BY MEDICAID OR SCHIP IN DEC18";
label variable MCDJA18X "COV BY MEDICAID OR SCHIP IN JAN18 (ED)";
label variable MCDFE18X "COV BY MEDICAID OR SCHIP IN FEB18 (ED)";
label variable MCDMA18X "COV BY MEDICAID OR SCHIP IN MAR18 (ED)";
label variable MCDAP18X "COV BY MEDICAID OR SCHIP IN APR18 (ED)";
label variable MCDMY18X "COV BY MEDICAID OR SCHIP IN MAY18 (ED)";
label variable MCDJU18X "COV BY MEDICAID OR SCHIP IN JUN18 (ED)";
label variable MCDJL18X "COV BY MEDICAID OR SCHIP IN JUL18 (ED)";
label variable MCDAU18X "COV BY MEDICAID OR SCHIP IN AUG18 (ED)";
label variable MCDSE18X "COV BY MEDICAID OR SCHIP IN SEP18 (ED)";
label variable MCDOC18X "COV BY MEDICAID OR SCHIP IN OCT18 (ED)";
label variable MCDNO18X "COV BY MEDICAID OR SCHIP IN NOV18 (ED)";
label variable MCDDE18X "COV BY MEDICAID OR SCHIP IN DEC18 (ED)";
label variable GVAJA18 "COV BY OTHER PUBLIC COVERAGE IN JAN18";
label variable GVAFE18 "COV BY OTHER PUBLIC COVERAGE IN FEB18";
label variable GVAMA18 "COV BY OTHER PUBLIC COVERAGE IN MAR18";
label variable GVAAP18 "COV BY OTHER PUBLIC COVERAGE IN APR18";
label variable GVAMY18 "COV BY OTHER PUBLIC COVERAGE IN MAY18";
label variable GVAJU18 "COV BY OTHER PUBLIC COVERAGE IN JUN18";
label variable GVAJL18 "COV BY OTHER PUBLIC COVERAGE IN JUL18";
label variable GVAAU18 "COV BY OTHER PUBLIC COVERAGE IN AUG18";
label variable GVASE18 "COV BY OTHER PUBLIC COVERAGE IN SEP18";
label variable GVAOC18 "COV BY OTHER PUBLIC COVERAGE IN OCT18";
label variable GVANO18 "COV BY OTHER PUBLIC COVERAGE IN NOV18";
label variable GVADE18 "COV BY OTHER PUBLIC COVERAGE IN DEC18";
label variable GVBJA18 "COV BY OTHER PUBLIC HMO IN JAN18";
label variable GVBFE18 "COV BY OTHER PUBLIC HMO IN FEB18";
label variable GVBMA18 "COV BY OTHER PUBLIC HMO IN MAR18";
label variable GVBAP18 "COV BY OTHER PUBLIC HMO IN APR18";
label variable GVBMY18 "COV BY OTHER PUBLIC HMO IN MAY18";
label variable GVBJU18 "COV BY OTHER PUBLIC HMO IN JUN18";
label variable GVBJL18 "COV BY OTHER PUBLIC HMO IN JUL18";
label variable GVBAU18 "COV BY OTHER PUBLIC HMO IN AUG18";
label variable GVBSE18 "COV BY OTHER PUBLIC HMO IN SEP18";
label variable GVBOC18 "COV BY OTHER PUBLIC HMO IN OCT18";
label variable GVBNO18 "COV BY OTHER PUBLIC HMO IN NOV18";
label variable GVBDE18 "COV BY OTHER PUBLIC HMO IN DEC18";
label variable GVCJA18 "COV BY OTHER PUBLIC PAYS PREM IN JAN18";
label variable GVCFE18 "COV BY OTHER PUBLIC PAYS PREM IN FEB18";
label variable GVCMA18 "COV BY OTHER PUBLIC PAYS PREM IN MAR18";
label variable GVCAP18 "COV BY OTHER PUBLIC PAYS PREM IN APR18";
label variable GVCMY18 "COV BY OTHER PUBLIC PAYS PREM IN MAY18";
label variable GVCJU18 "COV BY OTHER PUBLIC PAYS PREM IN JUN18";
label variable GVCJL18 "COV BY OTHER PUBLIC PAYS PREM IN JUL18";
label variable GVCAU18 "COV BY OTHER PUBLIC PAYS PREM IN AUG18";
label variable GVCSE18 "COV BY OTHER PUBLIC PAYS PREM IN SEP18";
label variable GVCOC18 "COV BY OTHER PUBLIC PAYS PREM IN OCT18";
label variable GVCNO18 "COV BY OTHER PUBLIC PAYS PREM IN NOV18";
label variable GVCDE18 "COV BY OTHER PUBLIC PAYS PREM IN DEC18";
label variable VAPJA18 "COVERED BY VA IN JAN18";
label variable VAPFE18 "COVERED BY VA IN FEB18";
label variable VAPMA18 "COVERED BY VA IN MAR18";
label variable VAPAP18 "COVERED BY VA IN APR18";
label variable VAPMY18 "COVERED BY VA IN MAY18";
label variable VAPJU18 "COVERED BY VA IN JUN18";
label variable VAPJL18 "COVERED BY VA IN JUL18";
label variable VAPAU18 "COVERED BY VA IN AUG18";
label variable VAPSE18 "COVERED BY VA IN SEP18";
label variable VAPOC18 "COVERED BY VA IN OCT18";
label variable VAPNO18 "COVERED BY VA IN NOV18";
label variable VAPDE18 "COVERED BY VA IN DEC18";
label variable IHSJA18 "COV BY INDIAN HEALTH SERVICE IN JAN18";
label variable IHSFE18 "COV BY INDIAN HEALTH SERVICE IN FEB18";
label variable IHSMA18 "COV BY INDIAN HEALTH SERVICE IN MAR18";
label variable IHSAP18 "COV BY INDIAN HEALTH SERVICE IN APR18";
label variable IHSMY18 "COV BY INDIAN HEALTH SERVICE IN MAY18";
label variable IHSJU18 "COV BY INDIAN HEALTH SERVICE IN JUN18";
label variable IHSJL18 "COV BY INDIAN HEALTH SERVICE IN JUL18";
label variable IHSAU18 "COV BY INDIAN HEALTH SERVICE IN AUG18";
label variable IHSSE18 "COV BY INDIAN HEALTH SERVICE IN SEP18";
label variable IHSOC18 "COV BY INDIAN HEALTH SERVICE IN OCT18";
label variable IHSNO18 "COV BY INDIAN HEALTH SERVICE IN NOV18";
label variable IHSDE18 "COV BY INDIAN HEALTH SERVICE IN DEC18";
label variable PUBJA18X "COVR BY ANY PUBLIC INS IN JAN18";
label variable PUBFE18X "COVR BY ANY PUBLIC INS IN FEB18";
label variable PUBMA18X "COVR BY ANY PUBLIC INS IN MAR18";
label variable PUBAP18X "COVR BY ANY PUBLIC INS IN APR18";
label variable PUBMY18X "COVR BY ANY PUBLIC INS IN MAY18";
label variable PUBJU18X "COVR BY ANY PUBLIC INS IN JUN18";
label variable PUBJL18X "COVR BY ANY PUBLIC INS IN JUL18";
label variable PUBAU18X "COVR BY ANY PUBLIC INS IN AUG18";
label variable PUBSE18X "COVR BY ANY PUBLIC INS IN SEP18";
label variable PUBOC18X "COVR BY ANY PUBLIC INS IN OCT18";
label variable PUBNO18X "COVR BY ANY PUBLIC INS IN NOV18";
label variable PUBDE18X "COVR BY ANY PUBLIC INS IN DEC18";
label variable PEGJA18 "COVERED BY EMPL UNION INS IN JAN18";
label variable PEGFE18 "COVERED BY EMPL UNION INS IN FEB18";
label variable PEGMA18 "COVERED BY EMPL UNION INS IN MAR18";
label variable PEGAP18 "COVERED BY EMPL UNION INS IN APR18";
label variable PEGMY18 "COVERED BY EMPL UNION INS IN MAY18";
label variable PEGJU18 "COVERED BY EMPL UNION INS IN JUN18";
label variable PEGJL18 "COVERED BY EMPL UNION INS IN JUL18";
label variable PEGAU18 "COVERED BY EMPL UNION INS IN AUG18";
label variable PEGSE18 "COVERED BY EMPL UNION INS IN SEP18";
label variable PEGOC18 "COVERED BY EMPL UNION INS IN OCT18";
label variable PEGNO18 "COVERED BY EMPL UNION INS IN NOV18";
label variable PEGDE18 "COVERED BY EMPL UNION INS IN DEC18";
label variable PDKJA18 "COVR BY PRIV INS (SOURCE UNKNWN) JAN18";
label variable PDKFE18 "COVR BY PRIV INS (SOURCE UNKNWN) FEB18";
label variable PDKMA18 "COVR BY PRIV INS (SOURCE UNKNWN) MAR18";
label variable PDKAP18 "COVR BY PRIV INS (SOURCE UNKNWN) APR18";
label variable PDKMY18 "COVR BY PRIV INS (SOURCE UNKNWN) MAY18";
label variable PDKJU18 "COVR BY PRIV INS (SOURCE UNKNWN) JUN18";
label variable PDKJL18 "COVR BY PRIV INS (SOURCE UNKNWN) JUL18";
label variable PDKAU18 "COVR BY PRIV INS (SOURCE UNKNWN) AUG18";
label variable PDKSE18 "COVR BY PRIV INS (SOURCE UNKNWN) SEP18";
label variable PDKOC18 "COVR BY PRIV INS (SOURCE UNKNWN) OCT18";
label variable PDKNO18 "COVR BY PRIV INS (SOURCE UNKNWN) NOV18";
label variable PDKDE18 "COVR BY PRIV INS (SOURCE UNKNWN) DEC18";
label variable PNGJA18 "COVERED BY NONGROUP INS IN JAN18";
label variable PNGFE18 "COVERED BY NONGROUP INS IN FEB18";
label variable PNGMA18 "COVERED BY NONGROUP INS IN MAR18";
label variable PNGAP18 "COVERED BY NONGROUP INS IN APR18";
label variable PNGMY18 "COVERED BY NONGROUP INS IN MAY18";
label variable PNGJU18 "COVERED BY NONGROUP INS IN JUN18";
label variable PNGJL18 "COVERED BY NONGROUP INS IN JUL18";
label variable PNGAU18 "COVERED BY NONGROUP INS IN AUG18";
label variable PNGSE18 "COVERED BY NONGROUP INS IN SEP18";
label variable PNGOC18 "COVERED BY NONGROUP INS IN OCT18";
label variable PNGNO18 "COVERED BY NONGROUP INS IN NOV18";
label variable PNGDE18 "COVERED BY NONGROUP INS IN DEC18";
label variable POGJA18 "COVERED BY OTHER GROUP INS IN JAN18";
label variable POGFE18 "COVERED BY OTHER GROUP INS IN FEB18";
label variable POGMA18 "COVERED BY OTHER GROUP INS IN MAR18";
label variable POGAP18 "COVERED BY OTHER GROUP INS IN APR18";
label variable POGMY18 "COVERED BY OTHER GROUP INS IN MAY18";
label variable POGJU18 "COVERED BY OTHER GROUP INS IN JUN18";
label variable POGJL18 "COVERED BY OTHER GROUP INS IN JUL18";
label variable POGAU18 "COVERED BY OTHER GROUP INS IN AUG18";
label variable POGSE18 "COVERED BY OTHER GROUP INS IN SEP18";
label variable POGOC18 "COVERED BY OTHER GROUP INS IN OCT18";
label variable POGNO18 "COVERED BY OTHER GROUP INS IN NOV18";
label variable POGDE18 "COVERED BY OTHER GROUP INS IN DEC18";
label variable POEJA18 "COV BY ESI, PHOLDER OUTSIDE RU IN JAN18";
label variable POEFE18 "COV BY ESI, PHOLDER OUTSIDE RU IN FEB18";
label variable POEMA18 "COV BY ESI, PHOLDER OUTSIDE RU IN MAR18";
label variable POEAP18 "COV BY ESI, PHOLDER OUTSIDE RU IN APR18";
label variable POEMY18 "COV BY ESI, PHOLDER OUTSIDE RU IN MAY18";
label variable POEJU18 "COV BY ESI, PHOLDER OUTSIDE RU IN JUN18";
label variable POEJL18 "COV BY ESI, PHOLDER OUTSIDE RU IN JUL18";
label variable POEAU18 "COV BY ESI, PHOLDER OUTSIDE RU IN AUG18";
label variable POESE18 "COV BY ESI, PHOLDER OUTSIDE RU IN SEP18";
label variable POEOC18 "COV BY ESI, PHOLDER OUTSIDE RU IN OCT18";
label variable POENO18 "COV BY ESI, PHOLDER OUTSIDE RU IN NOV18";
label variable POEDE18 "COV BY ESI, PHOLDER OUTSIDE RU IN DEC18";
label variable PNEJA18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN JAN18";
label variable PNEFE18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN FEB18";
label variable PNEMA18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN MAR18";
label variable PNEAP18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN APR18";
label variable PNEMY18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN MAY18";
label variable PNEJU18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN JUN18";
label variable PNEJL18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN JUL18";
label variable PNEAU18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN AUG18";
label variable PNESE18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN SEP18";
label variable PNEOC18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN OCT18";
label variable PNENO18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN NOV18";
label variable PNEDE18 "COV BY NON-ESI, PHLDR OUTSIDE RU IN DEC18";
label variable PRXJA18 "COV BY PRIV INS THROUGH EXCHNG IN JAN18";
label variable PRXFE18 "COV BY PRIV INS THROUGH EXCHNG IN FEB18";
label variable PRXMA18 "COV BY PRIV INS THROUGH EXCHNG IN MAR18";
label variable PRXAP18 "COV BY PRIV INS THROUGH EXCHNG IN APR18";
label variable PRXMY18 "COV BY PRIV INS THROUGH EXCHNG IN MAY18";
label variable PRXJU18 "COV BY PRIV INS THROUGH EXCHNG IN JUN18";
label variable PRXJL18 "COV BY PRIV INS THROUGH EXCHNG IN JUL18";
label variable PRXAU18 "COV BY PRIV INS THROUGH EXCHNG IN AUG18";
label variable PRXSE18 "COV BY PRIV INS THROUGH EXCHNG IN SEP18";
label variable PRXOC18 "COV BY PRIV INS THROUGH EXCHNG IN OCT18";
label variable PRXNO18 "COV BY PRIV INS THROUGH EXCHNG IN NOV18";
label variable PRXDE18 "COV BY PRIV INS THROUGH EXCHNG IN DEC18";
label variable PRIJA18 "COVERED BY PRIVATE INS IN JAN18";
label variable PRIFE18 "COVERED BY PRIVATE INS IN FEB18";
label variable PRIMA18 "COVERED BY PRIVATE INS IN MAR18";
label variable PRIAP18 "COVERED BY PRIVATE INS IN APR18";
label variable PRIMY18 "COVERED BY PRIVATE INS IN MAY18";
label variable PRIJU18 "COVERED BY PRIVATE INS IN JUN18";
label variable PRIJL18 "COVERED BY PRIVATE INS IN JUL18";
label variable PRIAU18 "COVERED BY PRIVATE INS IN AUG18";
label variable PRISE18 "COVERED BY PRIVATE INS IN SEP18";
label variable PRIOC18 "COVERED BY PRIVATE INS IN OCT18";
label variable PRINO18 "COVERED BY PRIVATE INS IN NOV18";
label variable PRIDE18 "COVERED BY PRIVATE INS IN DEC18";
label variable HPEJA18 "PHOLDER OF EMPL UNION INS IN JAN18";
label variable HPEFE18 "PHOLDER OF EMPL UNION INS IN FEB18";
label variable HPEMA18 "PHOLDER OF EMPL UNION INS IN MAR18";
label variable HPEAP18 "PHOLDER OF EMPL UNION INS IN APR18";
label variable HPEMY18 "PHOLDER OF EMPL UNION INS IN MAY18";
label variable HPEJU18 "PHOLDER OF EMPL UNION INS IN JUN18";
label variable HPEJL18 "PHOLDER OF EMPL UNION INS IN JUL18";
label variable HPEAU18 "PHOLDER OF EMPL UNION INS IN AUG18";
label variable HPESE18 "PHOLDER OF EMPL UNION INS IN SEP18";
label variable HPEOC18 "PHOLDER OF EMPL UNION INS IN OCT18";
label variable HPENO18 "PHOLDER OF EMPL UNION INS IN NOV18";
label variable HPEDE18 "PHOLDER OF EMPL UNION INS IN DEC18";
label variable HPDJA18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) JAN18";
label variable HPDFE18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) FEB18";
label variable HPDMA18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) MAR18";
label variable HPDAP18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) APR18";
label variable HPDMY18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) MAY18";
label variable HPDJU18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) JUN18";
label variable HPDJL18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) JUL18";
label variable HPDAU18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) AUG18";
label variable HPDSE18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) SEP18";
label variable HPDOC18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) OCT18";
label variable HPDNO18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) NOV18";
label variable HPDDE18 "PHOLDER OF PRIV INS (SOURCE UNKNWN) DEC18";
label variable HPNJA18 "PHOLDER OF NONGROUP INS IN JAN18";
label variable HPNFE18 "PHOLDER OF NONGROUP INS IN FEB18";
label variable HPNMA18 "PHOLDER OF NONGROUP INS IN MAR18";
label variable HPNAP18 "PHOLDER OF NONGROUP INS IN APR18";
label variable HPNMY18 "PHOLDER OF NONGROUP INS IN MAY18";
label variable HPNJU18 "PHOLDER OF NONGROUP INS IN JUN18";
label variable HPNJL18 "PHOLDER OF NONGROUP INS IN JUL18";
label variable HPNAU18 "PHOLDER OF NONGROUP INS IN AUG18";
label variable HPNSE18 "PHOLDER OF NONGROUP INS IN SEP18";
label variable HPNOC18 "PHOLDER OF NONGROUP INS IN OCT18";
label variable HPNNO18 "PHOLDER OF NONGROUP INS IN NOV18";
label variable HPNDE18 "PHOLDER OF NONGROUP INS IN DEC18";
label variable HPOJA18 "PHOLDER OF OTHER GROUP INS IN JAN18";
label variable HPOFE18 "PHOLDER OF OTHER GROUP INS IN FEB18";
label variable HPOMA18 "PHOLDER OF OTHER GROUP INS IN MAR18";
label variable HPOAP18 "PHOLDER OF OTHER GROUP INS IN APR18";
label variable HPOMY18 "PHOLDER OF OTHER GROUP INS IN MAY18";
label variable HPOJU18 "PHOLDER OF OTHER GROUP INS IN JUN18";
label variable HPOJL18 "PHOLDER OF OTHER GROUP INS IN JUL18";
label variable HPOAU18 "PHOLDER OF OTHER GROUP INS IN AUG18";
label variable HPOSE18 "PHOLDER OF OTHER GROUP INS IN SEP18";
label variable HPOOC18 "PHOLDER OF OTHER GROUP INS IN OCT18";
label variable HPONO18 "PHOLDER OF OTHER GROUP INS IN NOV18";
label variable HPODE18 "PHOLDER OF OTHER GROUP INS IN DEC18";
label variable HPXJA18 "PHOLDER OF PRIV INS THROUGH EXCH IN JAN18";
label variable HPXFE18 "PHOLDER OF PRIV INS THROUGH EXCH IN FEB18";
label variable HPXMA18 "PHOLDER OF PRIV INS THROUGH EXCH IN MAR18";
label variable HPXAP18 "PHOLDER OF PRIV INS THROUGH EXCH IN APR18";
label variable HPXMY18 "PHOLDER OF PRIV INS THROUGH EXCH IN MAY18";
label variable HPXJU18 "PHOLDER OF PRIV INS THROUGH EXCH IN JUN18";
label variable HPXJL18 "PHOLDER OF PRIV INS THROUGH EXCH IN JUL18";
label variable HPXAU18 "PHOLDER OF PRIV INS THROUGH EXCH IN AUG18";
label variable HPXSE18 "PHOLDER OF PRIV INS THROUGH EXCH IN SEP18";
label variable HPXOC18 "PHOLDER OF PRIV INS THROUGH EXCH IN OCT18";
label variable HPXNO18 "PHOLDER OF PRIV INS THROUGH EXCH IN NOV18";
label variable HPXDE18 "PHOLDER OF PRIV INS THROUGH EXCH IN DEC18";
label variable HPRJA18 "PHOLDER OF PRIVATE INSURANCE IN JAN18";
label variable HPRFE18 "PHOLDER OF PRIVATE INSURANCE IN FEB18";
label variable HPRMA18 "PHOLDER OF PRIVATE INSURANCE IN MAR18";
label variable HPRAP18 "PHOLDER OF PRIVATE INSURANCE IN APR18";
label variable HPRMY18 "PHOLDER OF PRIVATE INSURANCE IN MAY18";
label variable HPRJU18 "PHOLDER OF PRIVATE INSURANCE IN JUN18";
label variable HPRJL18 "PHOLDER OF PRIVATE INSURANCE IN JUL18";
label variable HPRAU18 "PHOLDER OF PRIVATE INSURANCE IN AUG18";
label variable HPRSE18 "PHOLDER OF PRIVATE INSURANCE IN SEP18";
label variable HPROC18 "PHOLDER OF PRIVATE INSURANCE IN OCT18";
label variable HPRNO18 "PHOLDER OF PRIVATE INSURANCE IN NOV18";
label variable HPRDE18 "PHOLDER OF PRIVATE INSURANCE IN DEC18";
label variable INSJA18X "COVR BY HOSP/MED INS IN JAN18";
label variable INSFE18X "COVR BY HOSP/MED INS IN FEB18";
label variable INSMA18X "COVR BY HOSP/MED INS IN MAR18";
label variable INSAP18X "COVR BY HOSP/MED INS IN APR18";
label variable INSMY18X "COVR BY HOSP/MED INS IN MAY18";
label variable INSJU18X "COVR BY HOSP/MED INS IN JUN18";
label variable INSJL18X "COVR BY HOSP/MED INS IN JUL18";
label variable INSAU18X "COVR BY HOSP/MED INS IN AUG18";
label variable INSSE18X "COVR BY HOSP/MED INS IN SEP18";
label variable INSOC18X "COVR BY HOSP/MED INS IN OCT18";
label variable INSNO18X "COVR BY HOSP/MED INS IN NOV18";
label variable INSDE18X "COVR BY HOSP/MED INS IN DEC18";
label variable PRVEV18 "EVER HAVE PRIVATE INSURANCE DURING 2018";
label variable TRIEV18 "EVER HAVE TRICARE/CHAMPVA DURING 2018";
label variable MCREV18 "EVER HAVE MEDICARE DURING 2018 (ED)";
label variable MCDEV18 "EVER HAVE MCAID/SCHIP DURING 2018 (ED)";
label variable VAEV18 "EVER HAVE VA DURING 2018";
label variable GVAEV18 "EVER HAVE OTHER PUBLIC DURING 2018";
label variable GVBEV18 "EVER HAVE OTHER PUBLIC HMO DURING 2018";
label variable GVCEV18 "EVER HAVE OTH PUB PAYS PREM DURING 2018";
label variable UNINS18 "UNINSURED ALL OF 2018";
label variable INSCOV18 "HEALTH INSURANCE COVERAGE INDICATOR 2018";
label variable INSURC18 "FULL YEAR INSURANCE COVERAGE STATUS 2018";
label variable TRIST31X "COV BY TRICARE STANDARD-ANY TIME IN R3/1";
label variable TRIST42X "COV BY TRICARE STANDARD-ANY TIME IN R4/2";
label variable TRIST18X "CV BY TRICARE STANDARD-R5/3 TIL 12/31/18";
label variable TRIPR31X "COV BY TRICARE PRIME - ANY TIME IN R3/1";
label variable TRIPR42X "COV BY TRICARE PRIME - ANY TIME IN R4/2";
label variable TRIPR18X "COV BY TRICARE PRIME-R5/3 UNTIL 12/31/18";
label variable TRIEX31X "COV BY TRICARE EXTRA - ANY TIME IN R3/1";
label variable TRIEX42X "COV BY TRICARE EXTRA - ANY TIME IN R4/2";
label variable TRIEX18X "COV BY TRICARE EXTRA - R5/3 TIL 12/31/18";
label variable TRILI31X "COV BY TRICARE FOR LIFE-ANY TIME IN R3/1";
label variable TRILI42X "COV BY TRICARE FOR LIFE-ANY TIME IN R4/2";
label variable TRILI18X "CV BY TRICARE FOR LIFE-R5/3 TIL 12/31/18";
label variable TRICH31X "COVERED BY CHAMPVA - ANY TIME IN R3/1";
label variable TRICH42X "COVERED BY CHAMPVA - ANY TIME IN R4/2";
label variable TRICH18X "COVERED BY CHAMPVA - R5/3 UNTIL 12/31/18";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD18 "COV BY MEDICARE PMED BENEFIT - 12/31/18";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD18X "COV BY MCARE PMED BENEFIT-12/31/18 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB18 "COV BY MEDICARE PART B - 12/31/18";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE/MEDICARE ADVANTAGE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE/MEDICARE ADVANTAGE - R4/2";
label variable MCRPHO18 "COV BY MEDICARE MANAGED CARE/MEDICARE ADVANTAGE - 12/31/18";
label variable MCDHMO31 "COV BY MCAID/SCHIP HMO -ANY TIME IN R3/1";
label variable MCDHMO42 "COV BY MCAID/SCHIP HMO -ANY TIME IN R4/2";
label variable MCDHMO18 "COV BY MCAID/SCHIP HMO-R5/3 TIL 12/31/18";
label variable MCDMC31 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R3/1";
label variable MCDMC42 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R4/2";
label variable MCDMC18 "CV MCD/CHIP GTKPR PLN-R5/3 TIL 12/31/18";
label variable PRVHMO31 "COVERED BY PRIVATE HMO-ANY TIME IN R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO-ANY TIME IN R4/2";
label variable PRVHMO18 "COVERED BY PRIVATE HMO-R5/3 TIL 12/31/18";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable PFSAMT31 "PERSON-LEVEL FSA TOTAL AMOUNT - R3/1";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 23 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 23 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR18X "COV BY TRICR/CHAMV - 12/31/18 (ED)";
label variable TRIAT31X "COV TRICARE/CHAMPVA - ANY TIME IN R3/1";
label variable TRIAT42X "COV TRICARE/CHAMPVA - ANY TIME IN R4/2";
label variable TRIAT53X "COV TRICARE/CHAMPVA - ANY TIME IN R5/3";
label variable TRIAT18X "COV TRICARE/CHAMPVA-R5/3 UNTIL 12/31/18";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID18 "COV BY MEDICAID OR SCHIP - 12/31/18";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID18X "COV BY MEDICAID OR SCHIP - 12/31/18 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE18 "COV BY MEDICARE - 12/31/18";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE18X "COV BY MEDICARE - 12/31/18 (ED)";
label variable MCDAT31X "COV MEDICAID OR SCHIP - ANY TIME IN R3/1";
label variable MCDAT42X "COV MEDICAID OR SCHIP - ANY TIME IN R4/2";
label variable MCDAT53X "COV MEDICAID OR SCHIP - ANY TIME IN R5/3";
label variable MCDAT18X "CV MCD/CHIP-ANY TME IN R5/3 TIL 12/31/18";
label variable GOVTA31 "COV BY OTHER PUBLIC COV - R3/1 INT DT";
label variable GOVTA42 "COV BY OTHER PUBLIC COV - R4/2 INT DT";
label variable GOVTA53 "COV BY OTHER PUBLIC COV 12-31/R3 INT DT";
label variable GOVTA18 "COV BY OTHER PUBLIC COV - 12/31/18";
label variable GOVAAT31 "COV BY OTHER PUBLIC-ANY TIME IN R3/1";
label variable GOVAAT42 "COV BY OTHER PUBLIC-ANY TIME IN R4/2";
label variable GOVAAT53 "COV BY OTHER PUBLIC-ANY TIME IN R5/3";
label variable GOVAAT18 "CV OTH PUB-ANY TME IN R5/3 TIL 12/31/18";
label variable GOVTB31 "COV BY OTH PUB HMO - R3/1 INT DT";
label variable GOVTB42 "COV BY OTH PUB HMO - R4/2 INT DT";
label variable GOVTB53 "COV BY OTH PUB HMO 12-31/R3 INT DT";
label variable GOVTB18 "COV BY OTH PUB HMO - 12/31/18";
label variable GOVBAT31 "COV BY OTH PUB HMO-ANY TIME IN R3/1";
label variable GOVBAT42 "COV BY OTH PUB HMO-ANY TIME IN R4/2";
label variable GOVBAT53 "COV BY OTH PUB HMO-ANY TIME IN R5/3";
label variable GOVBAT18 "COV OTH PB HMO-ANY TM R5/3 TIL 12/31/18";
label variable GOVTC31 "COV BY OTH PUB PAYS PREM - R3/1 INT DT";
label variable GOVTC42 "COV BY OTH PUB PAYS PREM - R4/2 INT DT";
label variable GOVTC53 "COV BY OTH PUB PAYS PREM 12-31/R3 INT DT";
label variable GOVTC18 "COV BY OTH PUB PAYS PREM - 12/31/18";
label variable GOVCAT31 "CV BY OTH PUB PAYS PREM-ANY TIME IN R3/1";
label variable GOVCAT42 "CV BY OTH PUB PAYS PREM-ANY TIME IN R4/2";
label variable GOVCAT53 "CV BY OTH PUB PAYS PREM-ANY TIME IN R5/3";
label variable GOVCAT18 "CV OTH PUB PAYS PREM- R5/3 TIL 12/31/18";
label variable VAPROG31 "COV BY VA - R3/1 INT DT";
label variable VAPROG42 "COV BY VA - R4/2 INT DT";
label variable VAPROG53 "COV BY VA 12-31/R3 INT DT";
label variable VAPROG18 "COV BY VA- 12/31/18";
label variable VAPRAT31 "COV BY VA - ANY TIME IN R3/1";
label variable VAPRAT42 "COV BY VA - ANY TIME IN R4/2";
label variable VAPRAT53 "COV BY VA - ANY TIME IN R5/3";
label variable VAPRAT18 "COV BY VA-ANY TME IN R5/3 TIL 12/31/18";
label variable IHS31 "CV BY INDIAN HEALTH SERVICE- R3/1 INT DT";
label variable IHS42 "CV BY INDIAN HEALTH SERVICE- R4/2 INT DT";
label variable IHS53 "CV BY IHS 12-31/R3 INT DT";
label variable IHS18 "COV BY IHS - 12/31/18";
label variable IHSAT31 "COV BY IHS - ANY TIME IN R3/1";
label variable IHSAT42 "COV BY IHS - ANY TIME IN R4/2";
label variable IHSAT53 "COV BY IHS - ANY TIME IN R5/3";
label variable IHSAT18 "COV BY IHS-ANY TME IN R5/3 TIL 12/31/18";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK18 "COV BY PRIV INS (DK PLAN) - 12/31/18";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU18 "COV BY EMPL/UNION GRP INS - 12/31/18";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING18 "COV BY NON-GROUP INS - 12/31/18";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG18 "COV BY OTHER GROUP INS - 12/31/18";
label variable PRINEO31 "COV BY NON-ESI, PHOLDR OUT RU - R3/1 INT DT";
label variable PRINEO42 "COV BY NON-ESI, PHOLDR OUT RU - R4/2 INT DT";
label variable PRINEO53 "COV BY NON-ESI, PHOLDR OUT RU 12-31/R3 INT DT";
label variable PRINEO18 "COV BY NON-ESI, PHOLDR OUT RU - 12/31/18";
label variable PRIEUO31 "COV BY ESI, PHOLDR OUTSIDE RU - R3/1 INT";
label variable PRIEUO42 "COV BY ESI, PHOLDR OUTSIDE RU - R4/2 INT";
label variable PRIEUO53 "CV BY ESI, PHLDR OUTSIDE RU 12-31/R3 INT";
label variable PRIEUO18 "COV BY ESI, PHOLDR OUTSIDE RU - 12/31/18";
label variable PRSTX31 "COV BY PRIV EXCHANGE INS -R3/1 INT DT";
label variable PRSTX42 "COV BY PRIV EXCHANGE INS -R4/2 INT DT";
label variable PRSTX53 "PRIV EXCHANGE INS ON 12-31 R5/R3 INT DT";
label variable PRSTX18 "PRIV EXCHANGE INSURANCE ON 12/31/18";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV18 "COV BY PRIV HLTH INS - 12/31/18";
label variable PRIVAT31 "COV BY PRIVATE INS - ANY TIME IN R3/1";
label variable PRIVAT42 "COV BY PRIVATE INS - ANY TIME IN R4/2";
label variable PRIVAT53 "COV BY PRIVATE INS - ANY TIME IN R5/3";
label variable PRIVAT18 "COV BY PRIVATE INS - R5/3 UNTIL 12/31/18";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB18X "COV BY PUBLIC INS - 12/31/18 (ED)";
label variable PUBAT31X "COV BY PUBLIC - ANY TIME IN R3/1";
label variable PUBAT42X "COV BY PUBLIC - ANY TIME IN R4/2";
label variable PUBAT53X "COV BY PUBLIC - ANY TIME IN R5/3";
label variable PUBAT18X "COV BY PUBLIC - R5/3 UNTIL 12/31/18";
label variable VERFLG31 "PID GAINED COVG THRU VERIFICATION R3/1";
label variable VERFLG42 "PID GAINED COVG THRU VERIFICATION R4/2";
label variable VERFLG18 "PID GAINED COVG THRU VERIFICATION IN R5/R3 UNTIL 12/31/18";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS18X "INSURED - 12/31/18 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT18X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/18";
label variable DENTIN31 "DENTAL INSURANCE - ANY TIME IN RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - ANY TIME IN RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - ANY TIME IN RD 5/3";
label variable DNTINS31 "DENTAL INS - ANY TIME IN RD 3/1 IN 2018";
label variable DNTINS18 "DENTL INS-ANY TIME IN R5/R3 TIL 12/31/18";
label variable PMEDIN31 "PMED INS - ANY TIME IN RD 3/1";
label variable PMEDIN42 "PMEDINS - ANY TIME IN RD 4/2";
label variable PMEDIN53 "PMEDINS - ANY TIME IN RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 2018";
label variable PMDINS18 "PMED INS - R5/R3 UNTIL 12/31/18";
label variable PROBPY42 "FAMILY HAVING PROB PAYING MEDICAL BILLS";
label variable CRFMPY42 "FAMILY MED BILLS BEING PAID OVER TIME";
label variable PYUNBL42 "UNABLE TO PAY FAMILY MEDICAL BILLS";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable TOTTCH18 "TOTAL HEALTH CARE CHARGES 18, EXCL RX";
label variable TOTEXP18 "TOTAL HEALTH CARE EXP 18";
label variable TOTSLF18 "TOTAL AMT PAID BY SELF/FAMILY 18";
label variable TOTMCR18 "TOTAL AMT PAID BY MEDICARE 18";
label variable TOTMCD18 "TOTAL AMT PAID BY MEDICAID 18";
label variable TOTPRV18 "TOTAL AMT PAID BY PRIVATE INS 18";
label variable TOTVA18 "TOTAL AMT PAID BY VA/CHAMPVA 18";
label variable TOTTRI18 "TOTAL AMT PAID BY TRICARE 18";
label variable TOTOFD18 "TOTAL AMT PAID BY OTHER FEDERAL 18";
label variable TOTSTL18 "TOTAL AMT PAID BY OTH ST/LOCAL 18";
label variable TOTWCP18 "TOTAL AMT PAID BY WORKERS COMP 18";
label variable TOTOPR18 "TOTAL AMT PAID BY OTHER PRIVATE 18";
label variable TOTOPU18 "TOTAL AMT PAID BY OTHER PUBLIC 18";
label variable TOTOSR18 "TOTAL AMT PAID BY OTHER SOURCES 18";
label variable TOTPTR18 "TOTAL AMT PAID BY PRV & TRI 18";
label variable TOTOTH18 "TOTAL AMT PAID BY OTH COMBINED 18";
label variable OBTOTV18 "# OFFICE-BASED PROVIDER VISITS 2018";
label variable OBVTCH18 "OFFICE-BASED PROVIDER VISIT CHARGES 18";
label variable OBVEXP18 "TOTAL OFFICE-BASED EXP 18";
label variable OBVSLF18 "ALL OFFICE VISITS - SELF/FAMILY AMT 18";
label variable OBVMCR18 "ALL OFFICE VISITS - MEDICARE AMT 18";
label variable OBVMCD18 "ALL OFFICE VISITS - MEDICAID AMT 18";
label variable OBVPRV18 "ALL OFFICE VISITS - PRIVATE INS AMT 18";
label variable OBVVA18 "ALL OFFICE VISITS-VA/CHAMPVA AMT 18";
label variable OBVTRI18 "ALL OFFICE VISITS-TRICARE AMT 18";
label variable OBVOFD18 "ALL OFFICE VISITS-OTHER FEDERAL AMT 18";
label variable OBVSTL18 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 18";
label variable OBVWCP18 "ALL OFFICE VISITS - WORKERS COMP AMT 18";
label variable OBVOPR18 "ALL OFFICE VISITS - OTH PRIVATE AMT 18";
label variable OBVOPU18 "ALL OFFICE VISITS - OTH PUBLIC AMT 18";
label variable OBVOSR18 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 18";
label variable OBVPTR18 "ALL OFFICE VISITS - PRV & TRI AMT 18";
label variable OBVOTH18 "ALL OFFICE VISITS - OTH COMBINED AMT 18";
label variable OBDRV18 "# OFFICE-BASED PHYSICIAN VISITS 18";
label variable OBDTCH18 "OFFICE-BASED PHYSICIAN VISIT CHARGES 18";
label variable OBDEXP18 "TOTAL OFF-BASED DR EXP 18";
label variable OBDSLF18 "DR OFFICE VISITS - SELF/FAMILY AMT 18";
label variable OBDMCR18 "DR OFFICE VISITS - MEDICARE AMT 18";
label variable OBDMCD18 "DR OFFICE VISITS - MEDICAID AMT 18";
label variable OBDPRV18 "DR OFFICE VISITS - PRIVATE INS AMT 18";
label variable OBDVA18 "DR OFFICE VISITS - VA/CHAMPVA AMT 18";
label variable OBDTRI18 "DR OFFICE VISITS - TRICARE AMT 18";
label variable OBDOFD18 "DR OFFICE VISITS - OTHER FEDERAL AMT 18";
label variable OBDSTL18 "DR OFFICE VISITS - OTH ST/LOCAL AMT 18";
label variable OBDWCP18 "DR OFFICE VISITS - WORKERS COMP AMT 18";
label variable OBDOPR18 "DR OFFICE VISITS - OTH PRIVATE AMT 18";
label variable OBDOPU18 "DR OFFICE VISITS - OTH PUBLIC AMT 18";
label variable OBDOSR18 "DR OFF VSTS - OTH UNCLASS SRCE AMT 18";
label variable OBDPTR18 "DR OFFICE VISITS - PRV & TRI AMT 18";
label variable OBDOTH18 "DR OFFICE VISITS - OTH COMBINED AMT 18";
label variable OPTOTV18 "# OUTPATIENT DEPT PROVIDER VISITS 2018";
label variable OPTTCH18 "OPD FACILITY + DR VISIT CHARGES - 18";
label variable OPTEXP18 "TOTAL OUTPATIENT FAC + DR EXP 18";
label variable OPTSLF18 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 18";
label variable OPTMCR18 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 18";
label variable OPTMCD18 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 18";
label variable OPTPRV18 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 18";
label variable OPTVA18 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 18";
label variable OPTTRI18 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 18";
label variable OPTOFD18 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 18";
label variable OPTSTL18 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 18";
label variable OPTWCP18 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 18";
label variable OPTOPR18 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 18";
label variable OPTOPU18 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 18";
label variable OPTOSR18 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 18";
label variable OPTPTR18 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 18";
label variable OPTOTH18 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 18";
label variable OPFTCH18 "OPD PROVIDER VISIT CHARGES - FAC 18";
label variable OPFEXP18 "TOTAL OUTPATIENT FACILITY EXP 18";
label variable OPFSLF18 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 18";
label variable OPFMCR18 "ALL OPD VISITS-MEDICARE AMT-FAC 18";
label variable OPFMCD18 "ALL OPD VISITS-MEDICAID AMT-FAC 18";
label variable OPFPRV18 "ALL OPD VISITS-PRIV INS AMT-FAC 18";
label variable OPFVA18 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 18";
label variable OPFTRI18 "ALL OPD VISITS-TRICARE AMT-FAC 18";
label variable OPFOFD18 "ALL OPD VISITS-OTHER FED AMT-FAC 18";
label variable OPFSTL18 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 18";
label variable OPFWCP18 "ALL OPD VISITS-WORKERS COMP AMT-FAC 18";
label variable OPFOPR18 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 18";
label variable OPFOPU18 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 18";
label variable OPFOSR18 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 18";
label variable OPFPTR18 "ALL OPD VISITS - PRV & TRI AMT-FAC 18";
label variable OPFOTH18 "ALL OPD VISITS - OTH COMBINED AMT-FAC 18";
label variable OPDEXP18 "TOTAL OUTPATIENT PROVIDER EXP 18";
label variable OPDTCH18 "OPD PROVIDER VISIT CHARGES - DR 18";
label variable OPDSLF18 "ALL OPD VISITS-SELF/FAMILY AMT-DR 18";
label variable OPDMCR18 "ALL OPD VISITS-MEDICARE AMT-DR 18";
label variable OPDMCD18 "ALL OPD VISITS-MEDICAID AMT-DR 18";
label variable OPDPRV18 "ALL OPD VISITS-PRIV INS AMT-DR 18";
label variable OPDVA18 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 18";
label variable OPDTRI18 "ALL OPD VISITS-TRICARE AMT-DR 18";
label variable OPDOFD18 "ALL OPD VISITS-OTHER FED AMT-DR 18";
label variable OPDSTL18 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 18";
label variable OPDWCP18 "ALL OPD VISITS-WORKERS COMP AMT-DR 18";
label variable OPDOPR18 "ALL OPD VISITS - OTH PRIVATE AMT-DR 18";
label variable OPDOPU18 "ALL OPD VISITS-OTH PUBLIC AMT-DR 18";
label variable OPDOSR18 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 18";
label variable OPDPTR18 "ALL OPD VISITS-PRV & TRI AMT -DR 18";
label variable OPDOTH18 "ALL OPD VISITS-OTH COMBINED AMT-DR 18";
label variable OPDRV18 "# OUTPATIENT DEPT PHYSICIAN VISITS 2018";
label variable OPVTCH18 "OPD PHYSICIAN VISIT CHARGES - FAC 18";
label variable OPVEXP18 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 18";
label variable OPVSLF18 "OPD DR VISITS-SELF/FAMILY AMT-FAC 18";
label variable OPVMCR18 "OPD DR VISITS-MEDICARE AMT-FAC 18";
label variable OPVMCD18 "OPD DR VISITS-MEDICAID AMT-FAC 18";
label variable OPVPRV18 "OPD DR VISITS-PRIV INS AMT-FAC 18";
label variable OPVVA18 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 18";
label variable OPVTRI18 "OPD DR VISITS-TRICARE AMT-FAC 18";
label variable OPVOFD18 "OPD DR VISITS-OTHER FED AMT-FAC 18";
label variable OPVSTL18 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 18";
label variable OPVWCP18 "OPD DR VISITS-WORKERS COMP AMT-FAC 18";
label variable OPVOPR18 "OPD DR VISITS - OTH PRIVATE AMT-FAC 18";
label variable OPVOPU18 "OPD DR VISITS-OTH PUBLIC AMT-FAC 18";
label variable OPVOSR18 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 18";
label variable OPVPTR18 "OPD DR VISITS - PRV & TRI AMT-FAC 18";
label variable OPVOTH18 "OPD DR VISITS - OTH COMBINED AMT-FAC 18";
label variable OPSEXP18 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 18";
label variable OPSTCH18 "OPD PHYSICIAN VISIT CHARGES - DR 18";
label variable OPSSLF18 "OPD DR VISITS-SELF/FAMILY AMT-DR 18";
label variable OPSMCR18 "OPD DR VISITS-MEDICARE AMT-DR 18";
label variable OPSMCD18 "OPD DR VISITS-MEDICAID AMT-DR 18";
label variable OPSPRV18 "OPD DR VISITS-PRIV INS AMT-DR 18";
label variable OPSVA18 "OPD DR VISITS-VA/CHAMPVA AMT-DR 18";
label variable OPSTRI18 "OPD DR VISITS-TRICARE AMT-DR 18";
label variable OPSOFD18 "OPD DR VISITS-OTHER FED AMT-DR 18";
label variable OPSSTL18 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 18";
label variable OPSWCP18 "OPD DR VISITS-WORKERS COMP AMT-DR 18";
label variable OPSOPR18 "OPD DR VISITS - OTH PRIVATE AMT-DR 18";
label variable OPSOPU18 "OPD DR VISITS-OTH PUBLIC AMT-DR 18";
label variable OPSOSR18 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 18";
label variable OPSPTR18 "OPD DR VISITS - PRV & TRI AMT-DR 18";
label variable OPSOTH18 "OPD DR VISITS -OTH COMBINED AMT-DR 18";
label variable ERTOT18 "# EMERGENCY ROOM VISITS 2018";
label variable ERTTCH18 "ER FACILITY + DR VISIT CHARGES 18";
label variable ERTEXP18 "TOTAL ER FACILITY + DR EXP 18";
label variable ERTSLF18 "ER-SELF/FAMILY AMT-(FAC+DR) 18";
label variable ERTMCR18 "ER-MEDICARE AMT-(FAC+DR) 18";
label variable ERTMCD18 "ER-MEDICAID AMT-(FAC+DR) 18";
label variable ERTPRV18 "ER-PRIV INS AMT-(FAC+DR) 18";
label variable ERTVA18 "ER-VA/CHAMPVA AMT-(FAC+DR) 18";
label variable ERTTRI18 "ER-TRICARE AMT-(FAC+DR) 18";
label variable ERTOFD18 "ER-OTHER FED AMT-(FAC+DR) 18";
label variable ERTSTL18 "ER-OTH ST/LOCAL AMT-(FAC+DR) 18";
label variable ERTWCP18 "ER-WORKERS COMP AMT-(FAC+DR) 18";
label variable ERTOPR18 "ER-OTH PRIVATE AMT-(FAC+DR) 18";
label variable ERTOPU18 "ER-OTH PUBLIC AMT-(FAC+DR) 18";
label variable ERTOSR18 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 18";
label variable ERTPTR18 "ER-PRV & TRI AMT (FAC+DR) 18";
label variable ERTOTH18 "ER -OTH COMBINED AMT (FAC+DR) 18";
label variable ERFTCH18 "ER FACILITY VISIT CHARGES 18";
label variable ERFEXP18 "TOTAL ER FACILITY EXP 18";
label variable ERFSLF18 "ER-SELF/FAMILY AMT - FAC 18";
label variable ERFMCR18 "ER-MEDICARE AMT - FAC 18";
label variable ERFMCD18 "ER-MEDICAID AMT - FAC 18";
label variable ERFPRV18 "ER-PRIVATE INS AMT - FAC 18";
label variable ERFVA18 "ER-VA/CHAMPVA AMT - FAC 18";
label variable ERFTRI18 "ER-TRICARE AMT - FAC 18";
label variable ERFOFD18 "ER-OTHER FEDERAL AMT - FAC 18";
label variable ERFSTL18 "ER-OTH ST/LOCAL AMT - FAC 18";
label variable ERFWCP18 "ER-WORKERS COMP AMT - FAC 18";
label variable ERFOPR18 "ER-OTHER PRIVATE AMT - FAC 18";
label variable ERFOPU18 "ER-OTHER PUBLIC AMT - FAC 18";
label variable ERFOSR18 "ER-OTH UNCLASS SRCE AMT - FAC 18";
label variable ERFPTR18 "ER-PRV & TRI AMT - FAC 18";
label variable ERFOTH18 "ER-OTH COMBINED AMT - FAC 18";
label variable ERDEXP18 "TOTAL EMERGENCY ROOM DR EXP 18";
label variable ERDTCH18 "ER DOCTOR VISIT CHARGES 18";
label variable ERDSLF18 "ER-SELF/FAMILY AMT - DR 18";
label variable ERDMCR18 "ER-MEDICARE AMT - DR 18";
label variable ERDMCD18 "ER-MEDICAID AMT - DR 18";
label variable ERDPRV18 "ER-PRIVATE INS AMT - DR 18";
label variable ERDVA18 "ER-VA/CHAMPVA AMT - DR 18";
label variable ERDTRI18 "ER-TRICARE AMT - DR 18";
label variable ERDOFD18 "ER-OTHER FED AMT - DR 18";
label variable ERDSTL18 "ER-OTH ST/LOCAL AMT - DR 18";
label variable ERDWCP18 "ER-WORKERS COMP AMT - DR 18";
label variable ERDOPR18 "ER - OTHER PRIVATE AMT - DR 18";
label variable ERDOPU18 "ER - OTHER PUBLIC AMT - DR 18";
label variable ERDOSR18 "ER-OTH UNCLASS SRCE AMT - DR 18";
label variable ERDPTR18 "ER-PRV & TRI AMT - DR 18";
label variable ERDOTH18 "ER-OTH COMBINED AMT - DR 18";
label variable IPDIS18 "# HOSPITAL DISCHARGES 2018";
label variable IPTEXP18 "TOT HOSP IP FACILITY + DR EXP 18";
label variable IPTTCH18 "IP HOSP STAY CHARGES (FAC+DR) 18";
label variable IPTSLF18 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 18";
label variable IPTMCR18 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 18";
label variable IPTMCD18 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 18";
label variable IPTPRV18 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 18";
label variable IPTVA18 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 18";
label variable IPTTRI18 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 18";
label variable IPTOFD18 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 18";
label variable IPTSTL18 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 18";
label variable IPTWCP18 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 18";
label variable IPTOPR18 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 18";
label variable IPTOPU18 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 18";
label variable IPTOSR18 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 18";
label variable IPTPTR18 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 18";
label variable IPTOTH18 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 18";
label variable IPFEXP18 "TOT HOSP IP FACILITY EXP-INC 0 NITES 18";
label variable IPFTCH18 "IP HOSP STAY CHARGES - FAC 18";
label variable IPFSLF18 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 18";
label variable IPFMCR18 "IP HOSP STAZ-MEDICARE AMT-FAC 18";
label variable IPFMCD18 "IP HOSP STAZ-MEDICAID AMT-FAC 18";
label variable IPFPRV18 "IP HOSP STAZ-PRIV INS AMT-FAC 18";
label variable IPFVA18 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 18";
label variable IPFTRI18 "IP HOSP STAZ-TRICARE AMT-FAC 18";
label variable IPFOFD18 "IP HOSP STAZ-OTHER FED AMT-FAC 18";
label variable IPFSTL18 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 18";
label variable IPFWCP18 "IP HOSP STAZ-WORKERS COMP AMT-FAC 18";
label variable IPFOPR18 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 18";
label variable IPFOPU18 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 18";
label variable IPFOSR18 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 18";
label variable IPFPTR18 "IP HOSP STAZ-PRV & TRI AMT-FAC 18";
label variable IPFOTH18 "IP HOSP STAZ-OTH COMBINED AMT-FAC 18";
label variable IPDEXP18 "TOTL HOSP STAZ DR EXP 18";
label variable IPDTCH18 "IP HOSP STAY CHARGES - DR 18";
label variable IPDSLF18 "IP HOSP STAZ-SELF/FAMILY AMT-DR 18";
label variable IPDMCR18 "IP HOSP STAZ-MEDICARE AMT- DR 18";
label variable IPDMCD18 "IP HOSP STAZ-MEDICAID AMT-DR 18";
label variable IPDPRV18 "IP HOSP STAZ-PRIV INS AMT-DR 18";
label variable IPDVA18 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 18";
label variable IPDTRI18 "IP HOSP STAZ-TRICARE AMT-DR 18";
label variable IPDOFD18 "IP HOSP STAZ-OTHER FED AMT-DR 18";
label variable IPDSTL18 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 18";
label variable IPDWCP18 "IP HOSP STAZ-WORKERS COMP AMT-DR 18";
label variable IPDOPR18 "IP HOSP STAZ - OTH PRIVATE AMT-DR 18";
label variable IPDOPU18 "IP HOSP STAZ - OTH PUBLIC AMT-DR 18";
label variable IPDOSR18 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 18";
label variable IPDPTR18 "IP HOSP STAZ-PRV & TRI AMT-DR 18";
label variable IPDOTH18 "IP HOSP STAZ-OTH COMBINED AMT-DR 18";
label variable IPNGTD18 "# NIGHTS IN HOSP FOR DISCHARGES, 2018";
label variable DVTOT18 "# DENTAL CARE VISITS 2018";
label variable DVTTCH18 "TOTAL DENTAL CARE VISIT CHARGES 18";
label variable DVTEXP18 "TOTAL DENTAL CARE EXP 18";
label variable DVTSLF18 "ALL DENTAL CARE - SELF/FAMILY AMT 18";
label variable DVTMCR18 "ALL DENTAL CARE - MEDICARE AMT 18";
label variable DVTMCD18 "ALL DENTAL CARE - MEDICAID AMT 18";
label variable DVTPRV18 "ALL DENTAL CARE - PRIVATE INS AMT 18";
label variable DVTVA18 "ALL DENTAL CARE - VA/CHAMPVA AMT 18";
label variable DVTTRI18 "ALL DENTAL CARE - TRICARE AMT 18";
label variable DVTOFD18 "ALL DENTAL CARE - OTHER FEDRL AMT 18";
label variable DVTSTL18 "ALL DENTAL CARE - OTH ST/LOCAL AMT 18";
label variable DVTWCP18 "ALL DENTAL CARE - WORKERS COMP AMT 18";
label variable DVTOPR18 "ALL DENTAL CARE - OTH PRIVATE AMT 18";
label variable DVTOPU18 "ALL DENTAL CARE - OTH PUBLIC AMT 18";
label variable DVTOSR18 "ALL DENT CARE-OT UNCLASS SRCE AMT 18";
label variable DVTPTR18 "ALL DENTAL CARE - PRV & TRI AMT 18";
label variable DVTOTH18 "ALL DENTAL CARE - OTH COMBINED AMT 18";
label variable HHTOTD18 "# HOME HEALTH PROVIDER DAYS 2018";
label variable HHAGD18 "# AGENCY HOME HEALTH PROVIDER DAYS 2018";
label variable HHATCH18 "HOME HEALTH AGENCY VISIT CHARGES 18";
label variable HHAEXP18 "TOTAL HOME HEALTH AGENCY EXP 18";
label variable HHASLF18 "HOME HLTH AGENCY - SELF/FAMILY AMT 18";
label variable HHAMCR18 "HOME HLTH AGENCY - MEDICARE AMT 18";
label variable HHAMCD18 "HOME HLTH AGENCY - MEDICAID AMT 18";
label variable HHAPRV18 "HOME HLTH AGENCY - PRIVATE INS AMT 18";
label variable HHAVA18 "HOME HLTH AGENCY-VA/CHAMPVA AMT 18";
label variable HHATRI18 "HOME HLTH AGENCY-TRICARE AMT 18";
label variable HHAOFD18 "HOME HLTH AGENCY - OTHER FED AMT 18";
label variable HHASTL18 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 18";
label variable HHAWCP18 "HOME HLTH AGENCY - WORKERS COMP AMT 18";
label variable HHAOPR18 "HOME HLTH AGENCY - OTH PRIVATE AMT 18";
label variable HHAOPU18 "HOME HLTH AGENCY - OTH PUBLIC AMT 18";
label variable HHAOSR18 "H HLTH AGENCY - OT UNCLASS SRCE AMT 18";
label variable HHAPTR18 "HOME HLTH AGENCY - PRV & TRI AMT 18";
label variable HHAOTH18 "HOME HLTH AGENCY - OTH COMBINED AMT 18";
label variable HHINDD18 "# NON-AGENCY HOME HLTH PROVIDR DAYS 2018";
label variable HHNTCH18 "HOME HEALTH NON-AGENCY VISIT CHARGES 18";
label variable HHNEXP18 "TOTAL HOME HEALTH NON-AGNCY EXP 18";
label variable HHNSLF18 "HOME HLTH NON-AGNCY - SELF/FAM AMT 18";
label variable HHNMCD18 "HOME HLTH NON-AGNCY - MEDICAID AMT 18";
label variable HHNMCR18 "HOME HLTH NON-AGNCY - MEDICARE AMT 18";
label variable HHNPRV18 "HOME HLTH NON-AGNCY - PRIV INS AMT 18";
label variable HHNVA18 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 18";
label variable HHNTRI18 "HOME HLTH NON-AGNCY-TRICARE AMT 18";
label variable HHNOFD18 "HOME HLTH NON-AGNCY-OTHR FED AMT 18";
label variable HHNSTL18 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 18";
label variable HHNWCP18 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 18";
label variable HHNOPR18 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 18";
label variable HHNOPU18 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 18";
label variable HHNOSR18 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 18";
label variable HHNPTR18 "HOME HLTH NON-AGNCY - PRV & TRI AMT 18";
label variable HHNOTH18 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 18";
label variable HHINFD18 "# INFORMAL HOME HLTH PROVIDER DAYS 2018";
label variable VISEXP18 "TOTAL GLASSES/CONTACT LENS EXP 18";
label variable VISTCH18 "GLASSES/CONTACT LENSES CHARGES 18";
label variable VISSLF18 "GLASSES/CNTCT LENSES -SELF/FAM AMT 18";
label variable VISMCR18 "GLASSES/CNTCT LENSES-MEDICARE AMT 18";
label variable VISMCD18 "GLASSES/CNTCT LENSES-MEDICAID AMT 18";
label variable VISPRV18 "GLASSES/CNTCT LENSES-PRIV INS AMT 18";
label variable VISVA18 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 18";
label variable VISTRI18 "GLASSES/LENSES-TRICARE AMT 18";
label variable VISOFD18 "GLASSES/CNTCT LENSES-OTHR FED AMT 18";
label variable VISSTL18 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 18";
label variable VISWCP18 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 18";
label variable VISOPR18 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 18";
label variable VISOPU18 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 18";
label variable VISOSR18 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 18";
label variable VISPTR18 "GLASSES/CNTCT LENSES-PRV & TRI AMT 18";
label variable VISOTH18 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 18";
label variable OTHTCH18 "OTHER EQUP/SUPPLIES CHARGES 18";
label variable OTHEXP18 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 18";
label variable OTHSLF18 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 18";
label variable OTHMCR18 "OTHER EQUP/SUPPLIES-MEDICARE AMT 18";
label variable OTHMCD18 "OTHER EQUP/SUPPLIES-MEDICAID AMT 18";
label variable OTHPRV18 "OTHER EQUP/SUPPLIES-PRIV INS AMT 18";
label variable OTHVA18 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 18";
label variable OTHTRI18 "OTHER EQUP/SUPPLY-TRICARE AMT 18";
label variable OTHOFD18 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 18";
label variable OTHSTL18 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 18";
label variable OTHWCP18 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 18";
label variable OTHOPR18 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 18";
label variable OTHOPU18 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 18";
label variable OTHOSR18 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 18";
label variable OTHPTR18 "OTHER EQUP/SUPPLY - PRV & TRI AMT 18";
label variable OTHOTH18 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 18";
label variable RXTOT18 "# PRESC MEDS INCL REFILLS 18";
label variable RXEXP18 "TOTAL RX-EXP 18";
label variable RXSLF18 "TOTAL RX-SELF/FAMILY AMT 18";
label variable RXMCR18 "TOTAL RX-MEDICARE AMT 18";
label variable RXMCD18 "TOTAL RX-MEDICAID AMT 18";
label variable RXPRV18 "TOTAL RX-PRIVATE INS AMT 18";
label variable RXVA18 "TOTAL RX-VA/CHAMPVA AMT 18";
label variable RXTRI18 "TOTAL RX-TRICARE AMT 18";
label variable RXOFD18 "TOTAL RX-OTHER FED AMT 18";
label variable RXSTL18 "TOTAL RX-OTHER ST/LOCAL AMT 18";
label variable RXWCP18 "TOTAL RX-WORKERS COMP AMT 18";
label variable RXOPR18 "TOTAL RX-OTH PRIVATE AMT 18";
label variable RXOPU18 "TOTAL RX-OTH PUBLIC AMT 18";
label variable RXOSR18 "TOT RX-OTH UNCLASS SRCE AMT 18";
label variable RXPTR18 "TOTAL RX-PRV & TRI AMT 18";
label variable RXOTH18 "TOTAL RX-OTH COMBINED AMT 18";
label variable PERWT18F "FINAL PERSON WEIGHT, 2018";
label variable FAMWT18F "FINAL FAMILY WEIGHT, 2018";
label variable FAMWT18C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/18";
label variable SAQWT18F "FINAL SAQ PERSON WEIGHT, 2018";
label variable DIABW18F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VSAQW18F "FINAL VSAQ PERSON WEIGHT, 2018";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2018";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2018";


*DEFINE VALUE LABELS FOR REPORTS;
label define H2090001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H2090002X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2090003X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2090004X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2090005X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090006X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2090007X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 UNDER 18"
         2 "2 18 TO 34"
         3 "3 35 TO 49"
         4 "4 50 OR OLDER" ;

label define H2090008X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO, OFFERED BUT REFUSED"
         3 "3 NO, FOR ANY OTHER REASON" ;

label define H2090009X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090010X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090011X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090012X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090013X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090014X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090015X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H2090016X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO, OFFERED BUT REFUSED"
         3 "3 NO, FOR ANY OTHER REASON" ;

label define H2090017X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090018X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090019X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090020X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H2090021X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H2090022X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090023X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2090024X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2090025X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2090026X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090027X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2090028X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090029X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090030X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2090031X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H2090032X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090033X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H2090034X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090035X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 WITHIN THE PAST 12 MONTHS"
         2 "2 WITHIN THE PAST ONE TO TWO YEARS"
         3 "3 WITHIN THE PAST TWO TO FIVE YEARS"
         4 "4 MORE THAN FIVE YEARS"
         5 "5 NEVER" ;

label define H2090036X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090037X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090038X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2090039X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2090040X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090041X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 EVERY DAY"
         2 "2 SOME DAYS"
         3 "3 NOT AT ALL" ;

label define H2090042X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090043X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H2090044X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090045X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YOUNGER THAN 35"
         2 "2 35 TO 44"
         3 "3 45 TO 54"
         4 "4 55 TO 64"
         5 "5 65 TO 74"
         6 "6 75 OR OLDER"
         7 "7 NEVER HAD PAP TEST" ;

label define H2090046X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2090047X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO, OFFERED BUT REFUSED"
         3 "3 NO, FOR ANY OTHER REASON" ;

label define H2090048X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090049X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 SELF ADMINISTERED"
         2 "2 HUSBAND OR WIFE"
         3 "3 UNMARRIED PARTNER"
         4 "4 MOTHER, FATHER OR GUARDIAN"
         5 "5 SON OR DAUGHTER"
         6 "6 OTHER RELATIVE"
         7 "7 NOT RELATED" ;

label define H2090050X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2090051X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER HAD A PSA TEST"
         2 "2 UNDER AGE 50"
         3 "3 BETWEEN 50 AND 64"
         4 "4 BETWEEN 64 AND 74"
         5 "5 75 OR OLDER" ;

label define H2090052X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090053X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090054X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090055X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2090056X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090057X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090058X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2090059X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H2090060X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO, OFFERED BUT REFUSED"
         3 "3 NO, FOR ANY OTHER REASON" ;

label define H2090061X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO, OFFERED BUT REFUSED"
         3 "3 NO, FOR ANY OTHER REASON" ;

label define H2090062X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H2090063X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090064X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090065X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090066X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090067X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2090068X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2090069X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090070X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090071X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090072X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090073X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H2090074X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090075X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090076X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090077X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090078X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090079X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090080X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090081X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H2090082X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090083X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090084X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090085X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090086X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090087X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090088X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090089X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090090X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090091X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090092X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090093X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1  WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3  WITHIN PAST 5 YEARS"
         4 "4  MORE THAN 5 YEARS"
         5 "5  NEVER" ;

label define H2090094X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H2090095X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090096X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090097X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090098X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2017 "2017 YEAR"
         2018 "2018 YEAR" ;

label define H2090099X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2018 "2018 YEAR" ;

label define H2090100X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2018 "2018 YEAR"
         2019 "2019 YEAR" ;

label define H2090101X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2090102X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090103X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090104X
         -1 "-1 INAPPLICABLE, THOSE WHO ARE DEC/INSTD"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090105X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090106X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2090107X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2090108X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2090109X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2090110X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2090111X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2090112X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090113X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090114X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090115X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090116X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090117X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090118X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090119X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090120X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090121X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090122X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090123X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090124X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090125X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090126X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090127X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090128X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090129X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090130X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090131X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090132X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H2090133X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H2090134X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090135X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090136X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090137X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090138X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090139X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090140X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090141X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090142X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090143X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090144X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090145X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090146X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090147X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090148X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090149X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090150X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090151X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090152X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090153X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090154X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090155X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090156X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H2090158X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090159X
         0 "0 NOT ELIGIBLE FOR DCS"
         1 "1 ELIGIBLE FOR DCS AND HAS DCS DATA"
         2 "2 ELIGIBLE FOR DCS, BUT NO DCS DATA" ;

label define H2090160X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H2090161X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2090162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090163X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090164X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090165X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090166X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090167X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090168X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090169X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090170X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090171X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090172X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090173X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2090174X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2090175X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2090176X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2090177X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2090178X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2090179X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090180X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090181X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090182X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090183X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090184X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090185X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090186X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090187X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -8 "-8 DK"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H2090188X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090189X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090190X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090191X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090192X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090193X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090194X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090195X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090196X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H2090197X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090198X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090199X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090200X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090201X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090202X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090203X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090204X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090205X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090206X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090207X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090208X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090209X
         -1 "-1  INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090210X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090211X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090212X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090213X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090214X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090215X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090216X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090217X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090218X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090219X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090220X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090221X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090222X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090223X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H2090224X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2090225X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2090226X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2090227X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2090228X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090229X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090230X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H2090231X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 3/1" ;

label define H2090232X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H2090233X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 4/2" ;

label define H2090234X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H2090235X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 5/3" ;

label define H2090236X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090237X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090238X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090239X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090240X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2017 "2017 YEAR"
         2018 "2018 YEAR" ;

label define H2090241X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2017 "2017 YEAR"
         2018 "2018 YEAR" ;

label define H2090242X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2018 "2018 YEAR" ;

label define H2090243X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         2018 "2018 YEAR"
         2019 "2019 YEAR" ;

label define H2090244X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090245X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090246X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090247X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090248X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H2090249X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H2090250X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H2090251X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H2090252X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H2090253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090254X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H2090255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H2090256X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H2090257X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2090258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2090259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2090260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H2090261X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090262X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2090263X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2090264X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2090265X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2090266X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H2090267X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090268X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090269X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090270X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090271X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090272X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090273X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090274X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090275X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090276X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090277X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090278X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090279X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090280X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090281X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090282X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090283X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090284X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090285X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090286X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090287X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090288X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090289X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090290X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090291X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090292X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090293X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090294X
         1 "1 YES"
         2 "2 NO" ;

label define H2090295X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090296X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090297X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090298X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090299X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090300X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090301X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090302X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090303X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090304X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090305X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090306X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090307X
         1 "1 YES"
         2 "2 NO" ;

label define H2090308X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090309X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090310X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090311X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090312X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090313X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090314X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090315X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090316X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090317X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090318X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090319X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090320X
         1 "1 YES"
         2 "2 NO" ;

label define H2090321X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090322X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090323X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090324X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090325X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090326X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090327X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090328X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090329X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090330X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090331X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090332X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090333X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090334X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090335X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090336X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090337X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090338X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090339X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090340X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090341X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090342X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H2090343X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H2090344X
         -1 "-1 INAPPLICABLE"
         1 "1 MEXICAN/MEX AMER/CHICANO-NO OTHER HISP"
         2 "2 PUERTO RICAN -NO OTHER HISP REPORTED"
         3 "3 CUBAN/CUBAN AMERICAN -NO OTHER HISP RPTD"
         4 "4 DOMINICAN -NO OTHER HISP REPORTED"
         5 "5 CENTRAL OR SOUTH AMERICAN -NO OTHER HISP"
         6 "6 OTH LAT AM/HISP/LATINO/SPNSH ORGN-NO OTH"
         8 "8 MULTIPLE HISPANIC GROUPS REPORTED"
         9 "9 NON-HISPANIC" ;

label define H2090345X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H2090346X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H2090347X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090348X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090349X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090350X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090351X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090352X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090353X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090372X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090422X
         -1 "-1 INAPPLICABLE"
         -15 "-15 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2090423X
         -1 "-1 INAPPLICABLE"
         -15 "-15 UNKNOWN (NOT IMPUTED)"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2090424X
         -1 "-1 INAPPLICABLE"
         -15 "-15 UNKNOWN (NOT IMPUTED)"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2090425X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE >= $96.15" ;

label define H2090426X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090427X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE >= $96.15" ;

label define H2090428X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND" ;

label define H2090429X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE >= $96.15" ;

label define H2090430X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND" ;

label define H2090431X
         0 "0 NO"
         1 "1 YES" ;

label define H2090432X
         0 "0 NO"
         1 "1 YES" ;

label define H2090433X
         0 "0 NO"
         1 "1 YES" ;

label define H2090434X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090435X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090436X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 VERY WELL"
         2 "2 WELL"
         3 "3 NOT WELL"
         4 "4 NOT AT ALL"
         5 "5 UNDER 5 IN ROUND 1 AND OTHLANG=1, INAPP" ;

label define H2090437X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 VERY WELL"
         2 "2 WELL"
         3 "3 NOT WELL"
         4 "4 NOT AT ALL"
         5 "5 UNDER 5 YEARS OLD, INAPPLICABLE" ;

label define H2090438X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090440X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090441X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090452X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090456X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090457X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090458X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090459X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2090460X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2090461X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2090462X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2090463X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2090464X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2090465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090472X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090475X
         1 "1 IN-SCOPE ON 12/31/2018"
         2 "2 NOT IN-SCOPE ON 12/31/2018" ;

label define H2090476X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/18"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2090477X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/18"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2090478X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/18"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2090479X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/18"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2090480X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2018"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2018" ;

label define H2090481X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H2090482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090492X
         -1 "-1 INAPPLICABLE"
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 PUBLIC ONLY"
         3 "3 <65 UNINSURED"
         4 "4 65+ EDITED MEDICARE ONLY"
         5 "5 65+ EDITED MEDICARE AND PRIVATE"
         6 "6 65+ EDITED MEDICARE AND OTH PUB ONLY"
         7 "7 65+ UNINSURED"
         8 "8 65+ NO MEDICARE AND ANY PUBLIC/PRIVATE" ;

label define H2090493X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090494X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H2090495X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090496X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090497X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090498X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2090499X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2090500X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2090501X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H2090502X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2090503X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2090504X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2090505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090506X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090507X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090508X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H2090509X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPANISH"
         2 "2 ANOTHER LANGUAGE" ;

label define H2090510X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090511X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H2090512X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H2090513X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090514X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H2090515X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2090516X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2090517X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2090518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090544X
         1 "1 YES"
         2 "2 NO" ;

label define H2090545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090547X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP - HMO CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2090548X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP - HMO CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2090549X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP - HMO CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2090550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090558X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP-GTKPR CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2090559X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP-GTKPR CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2090560X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCAID/SCHIP-GTKPR CANNOT BE COMPUTED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2090561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090563X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090575X
         1 "1 YES"
         2 "2 NO" ;

label define H2090576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090592X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MEDICARE - PART B CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090593X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MEDICARE - PART B CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090594X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MEDICARE - PART B CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090595X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090596X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090597X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090598X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090599X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090600X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - PMED BENEFIT CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090601X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - MANAGED CARE CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090602X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - MANAGED CARE CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090603X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY MCARE - MANAGED CARE CANNOT BE COMPUTED"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2090604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090605X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090606X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090607X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H2090608X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090609X
         -1 "-1 INAPPLICALBE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090610X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090611X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2090612X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2090613X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2090614X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2090615X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090616X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090617X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090618X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090619X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090620X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090621X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090622X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2090623X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2090624X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2090625X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090626X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >= $96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090627X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >= $96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090628X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >= $96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090629X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090630X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090631X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090632X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090633X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 GOING TO SCHOOL"
         5 "5 TAKING CARE OF HOME OR FAMILY"
         6 "6 DON'T WANT TO WORK"
         91 "91 OTHER" ;

label define H2090634X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 GOING TO SCHOOL"
         5 "5 TAKING CARE OF HOME OR FAMILY"
         6 "6 DON'T WANT TO WORK"
         91 "91 OTHER" ;

label define H2090635X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 GOING TO SCHOOL"
         5 "5 TAKING CARE OF HOME OR FAMILY"
         6 "6 DON'T WANT TO WORK"
         91 "91 OTHER" ;

label define H2090636X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090637X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090638X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2090639X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2090640X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2090641X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2090642X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2090643X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2090644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090645X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090646X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090647X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090648X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090649X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090650X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090651X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090652X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090653X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090654X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090655X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090656X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090657X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EVERY DAY"
         2 "2 SOME DAYS"
         3 "3 NOT AT ALL" ;

label define H2090658X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090659X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090660X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HEART MURMUR"
         10 "10 BRADYCARDIA/SLOW HEART RATE"
         2 "2 HEART ARRHYTHMIA/IRREGULAR HEARTBEAT"
         3 "3 BLOCKED OR CLOGGED ARTERY"
         4 "4 CONGESTIVE HEART FAILURE"
         5 "5 ATRIAL FIBRILLATION"
         6 "6 MITRAL VALVE PROLAPSE"
         7 "7 ENLARGED HEART"
         8 "8 HEART VALVE PROBLEMS"
         9 "9 TACHYCARDIA/RAPID HEART RATE"
         91 "91 OTHER SPECIFY" ;

label define H2090661X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090662X
         -15 "-15 CANNOT BE COMPUTED"
         0 "0" ;

label define H2090663X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090664X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090665X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090666X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO"
         5 "5 UNDER 5 YEARS OLD, INAPPLICABLE" ;

label define H2090667X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H2090668X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090669X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090670X
         22 "22 PANEL 22"
         23 "23 PANEL 23" ;

label define H2090671X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090673X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090675X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090677X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090678X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090679X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090694X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090695X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090704X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090705X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H2090706X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H2090707X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2090708X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090709X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090710X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H2090711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090716X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2090717X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2090718X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2090719X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090720X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090721X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090757X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090758X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090759X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090760X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090761X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090762X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090763X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090764X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090765X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090766X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090767X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090769X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090770X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H2090771X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 OWN PRACTICE, NOT PART OF GROUP/FAC"
         2 "2 PRACTICE ASSOCIATED WITH GROUP/FAC" ;

label define H2090772X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090773X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090774X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090775X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090776X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090777X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090778X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090779X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090780X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090781X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090782X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090783X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090784X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090785X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090786X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090787X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090789X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090791X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090792X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090793X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090794X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090795X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090796X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090797X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090798X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090799X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090800X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090801X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090803X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090805X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090806X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090807X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090808X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090809X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090810X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090811X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090812X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090813X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090814X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090815X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090816X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090817X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090818X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H2090819X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2090820X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2090821X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2090822X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2090823X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090824X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090825X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090826X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090827X
         1 "1 YES"
         2 "2 NO" ;

label define H2090828X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY PRIVATE - HMO CANNOT BE COMPUTED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2090829X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY PRIVATE - HMO CANNOT BE COMPUTED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2090830X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY PRIVATE - HMO CANNOT BE COMPUTED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2090831X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090832X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090833X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090834X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090835X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090836X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090837X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090838X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090839X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090840X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090841X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090844X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2090845X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2090846X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2090847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090852X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090853X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090854X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090859X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090863X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090864X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090865X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090868X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090872X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2090873X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2090874X
         -1 "-1 INAPPLICABLE"
         1 "1 HISPANIC"
         2 "2 NON-HISPANIC WHITE ONLY"
         3 "3 NON-HISPANIC BLACK ONLY"
         4 "4 NON-HISPANIC ASIAN ONLY"
         5 "5 NON-HISPANIC OTHER RACE OR MULTIPLE RACE" ;

label define H2090875X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H2090876X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         10 "10 OTH ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         12 "12 MULTIPLE RACES REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN INDIAN - NO OTHER RACE REPORTED"
         5 "5 CHINESE - NO OTHER RACE REPORTED"
         6 "6 FILIPINO - NO OTHER RACE REPORTED" ;

label define H2090877X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2090878X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2090879X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED" ;

label define H2090880X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H2090881X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H2090882X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED" ;

label define H2090883X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2090884X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2090885X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2090886X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2090887X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2090888X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2090889X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2090890X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2090891X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090892X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090893X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090894X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H2090895X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2090896X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2090897X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2090898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090900X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090901X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2090902X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2090903X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2090904X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2090905X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H2090906X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H2090907X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H2090908X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H2090909X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090910X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090911X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H2090912X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090916X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090917X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090918X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090919X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H2090920X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090921X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090922X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090926X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090927X
         -1 "-1 INAPPLICABLE"
         -9 "-9 CANNOT BE COMPUTED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2090928X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2090929X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2090930X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H2090931X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2090932X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2090933X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2090934X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2090935X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090936X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090937X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2090938X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2090939X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2090940X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090941X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090942X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2090943X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090944X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090945X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090946X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2090947X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H2090948X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK" ;

label define H2090949X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090950X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H2090951X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2090952X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2090953X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2090954X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090955X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H2090956X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090958X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090959X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090960X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090961X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090962X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090963X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-CHAMPVA CANNOT BE COMPUTED"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090964X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-CHAMPVA CANNOT BE COMPUTED"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090965X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-CHAMPVA CANNOT BE COMPUTED"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090967X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090968X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090969X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090970X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090971X
         1 "1 YES"
         2 "2 NO" ;

label define H2090972X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI EXTRA CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090973X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI EXTRA CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090974X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI EXTRA CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090975X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090976X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090977X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090978X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090979X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI FOR LIFE CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090980X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI FOR LIFE CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090981X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI FOR LIFE CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090982X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090983X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090984X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090985X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090986X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI PRIME CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090987X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI PRIME CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090988X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI PRIME CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090989X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2090990X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI STANDARD CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090991X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI STANDARD CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090992X
         -1 "-1 INAPPLICABLE"
         -15 "-15 COV BY TRICR/CHAMV-TRI STANDARD CANNOT BE COMPUTED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2090993X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090994X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H2090995X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090996X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2090997X
         1 "1 YES"
         2 "2 NO" ;

label define H2090998X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2090999X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091000X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2091001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091002X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2091003X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091004X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091005X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091006X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 DID NOT RECEIVE HEALTH CARE SERVICES AT THE VA IN THE LAST 12 MONTHS"
         1 "1 YES"
         2 "2 NO" ;

label define H2091007X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091008X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2091009X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         2018 "2018 YEAR"
         2019 "2019 YEAR" ;

label define H2091010X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2091011X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091012X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2091013X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2091014X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -16 "-16 NO ADUTY RPTD, BUT RCVD VA HCARE SVC"
         1 "1 NO, NEVER SERVED IN THE MILITARY"
         2 "2 YES, ADUTY ONLY TRAIN RESERVES/NATL GUARD"
         3 "3 YES, AND I AM STILL ON ACTIVE DUTY"
         4 "4 YES, ACTIVE DUTY IN THE PAST, BUT NOT NOW" ;

label define H2091015X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091016X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091017X
         1 "1 YES"
         2 "2 NO" ;

label define H2091018X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2091019X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091020X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091021X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2091022X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091023X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091024X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091025X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2091026X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2091027X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2091028X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091029X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091030X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091031X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2091032X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2091033X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091034X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091035X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091036X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2091037X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091038X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2091039X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2091040X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 NOT RECV HCARE SVC OUTSD VA IN LAST 12 MOS"
         1 "1 YES"
         2 "2 NO" ;

label define H2091041X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2091042X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091043X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091044X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2091045X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2091046X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NOT A PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 A BIG PROBLEM" ;

label define H2091047X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091048X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091050X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091051X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091052X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091053X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091054X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091055X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091056X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091057X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091058X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091059X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091060X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091061X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NOT A PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 A BIG PROBLEM" ;

label define H2091062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091066X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2091067X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091068X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 SELF ADMINISTERED"
         2 "2 HUSBAND OR WIFE"
         3 "3 UNMARRIED PARTNER"
         4 "4 MOTHER, FATHER, OR GUARDIAN"
         5 "5 SON OR DAUGHTER"
         6 "6 OTHER RELATIVE"
         7 "7 NOT RELATED" ;

label define H2091069X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2091070X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091071X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2091072X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2091073X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2091074X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091075X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES, FROM THE VA"
         2 "2 YES, FROM OUTSIDE THE VA"
         3 "3 YES, FROM THE VA AND FROM OUTSIDE THE VA"
         4 "4 NO, DID NOT RECEIVE THIS SERVICE" ;

label define H2091076X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091077X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091078X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         0 "0 DID NOT RECEIVE HEALTH CARE SERVICES AT THE VA IN THE LAST 12 MONTHS"
         1 "1 YES"
         2 "2 NO" ;

label define H2091079X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 NOT A PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 A BIG PROBLEM" ;

label define H2091080X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091081X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         1 "1 MAJOR FACTOR"
         2 "2 MINOR FACTOR"
         3 "3 NOT A FACTOR"
         4 "4 DO NOT KNOW" ;

label define H2091082X
         -1 "-1 INAPPLICABLE"
         1 "1 PID GAINED COVG THRU VERIFICATION ROUND 1"
         2 "2 PID GAINED COVG THRU VERIFICATION ROUND 2"
         3 "3 PID GAINED COVG THRU VERIFICATION ROUND 3"
         4 "4 PID GAINED COVG THRU VERIFICATION ROUND 4"
         5 "5 PID GAINED COVG THRU VERIFICATION ROUND 5"
         95 "95 NOT COVERED THRU VERIFICATION SERIES" ;

label define H2091083X
         -1 "-1 INAPPLICABLE"
         1 "1 PID GAINED COVG THRU VERIFICATION ROUND 1"
         2 "2 PID GAINED COVG THRU VERIFICATION ROUND 2"
         3 "3 PID GAINED COVG THRU VERIFICATION ROUND 3"
         4 "4 PID GAINED COVG THRU VERIFICATION ROUND 4"
         5 "5 PID GAINED COVG THRU VERIFICATION ROUND 5"
         95 "95 NOT COVERED THRU VERIFICATION SERIES" ;

label define H2091084X
         -1 "-1 INAPPLICABLE"
         1 "1 PID GAINED COVG THRU VERIFICATION ROUND 1"
         2 "2 PID GAINED COVG THRU VERIFICATION ROUND 2"
         3 "3 PID GAINED COVG THRU VERIFICATION ROUND 3"
         4 "4 PID GAINED COVG THRU VERIFICATION ROUND 4"
         5 "5 PID GAINED COVG THRU VERIFICATION ROUND 5"
         95 "95 NOT COVERED THRU VERIFICATION SERIES" ;

label define H2091085X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2091086X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2091087X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED" ;

label define H2091088X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H2091089X
         0 "0 NOT ELIGIBLE FOR VSAQ"
         1 "1 ELIGIBLE FOR VSAQ - HAS VSAQ DATA"
         2 "2 ELIGIBLE FOR VSAQ - NO VSAQ DATA" ;

label define H2091090X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2091091X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2091092X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2091093X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091094X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091095X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091096X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091097X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091098X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091099X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091100X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091101X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2091102X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SPANISH"
         2 "2 ANOTHER LANGUAGE"
         5 "5 UNDER 5 YEARS OLD, INAPPLICABLE" ;

label define H2091103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2091104X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2091105X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2091106X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2091107X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JOB ENDED, TEMPORARY, SEASONAL, CONTRACT, ETC"
         10 "10 QUIT - ANY OTHER REASON"
         2 "2 BUSINESS CLOSED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS, INJURY, ANY HEALTH PROBLEM"
         5 "5 TERMINATED, FIRED, DISMISSED"
         6 "6 LAID OFF, LET GO"
         7 "7 QUIT - FAMILY REASON, MATERNITY LEAVE"
         8 "8 QUIT - SCHOOL"
         9 "9 QUIT - JOB RELATED REASON"
         91 "91 OTHER" ;

label define H2091108X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 JOB ENDED, TEMPORARY, SEASONAL, CONTRACT, ETC"
         10 "10 QUIT - ANY OTHER REASON"
         2 "2 BUSINESS CLOSED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS, INJURY, ANY HEALTH PROBLEM"
         5 "5 TERMINATED, FIRED, DISMISSED"
         6 "6 LAID OFF, LET GO"
         7 "7 QUIT - FAMILY REASON, MATERNITY LEAVE"
         8 "8 QUIT - SCHOOL"
         9 "9 QUIT - JOB RELATED REASON"
         91 "91 OTHER" ;

label define H2091109X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SELDOM OR NEVER GETS SICK"
         2 "2 RECENTLY MOVED INTO AREA"
         3 "3 JUST CHANGED INSURANCE PLANS"
         4 "4 NO HEALTH INSURANCE, OTHER INSURANCE-RELATED REASON"
         5 "5 DO NOT KNOW WHERE TO GO FOR CARE"
         6 "6 USC IN THIS AREA NO LONGER AVAILABLE"
         7 "7 LIKES TO GO TO DIFFERENT PLACES FOR DIFFERENT HEALTH NEEDS"
         8 "8 DON'T USE DOCTORS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H2091110X
         -1 "-1 INAPPLICABLE"
         -15 "-15 CANNOT BE COMPUTED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 YR., LESS THAN 5 YRS."
         3 "3 5 YRS., LESS THAN 10 YRS."
         4 "4 10 YRS., LESS THAN 15 YRS."
         5 "5 15 YEARS OR MORE" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H2090001X;
label value ACTDTY31 H2090002X;
label value ACTDTY42 H2090003X;
label value ACTDTY53 H2090004X;
label value ACTLIM31 H2090005X;
label value ADACLS42 H2090006X;
label value ADAGE42 H2090007X;
label value ADBLDS42 H2090008X;
label value ADBMI42 H2090009X;
label value ADBNDN42 H2090010X;
label value ADBPCK42 H2090011X;
label value ADBRST42 H2090012X;
label value ADBRTC42 H2090013X;
label value ADCHLC42 H2090014X;
label value ADCLIM42 H2090015X;
label value ADCLNS42 H2090016X;
label value ADCMPM42 H2090017X;
label value ADCMPY42 H2090018X;
label value ADCOLN42 H2090019X;
label value ADDAYA42 H2090020X;
label value ADDPRS42 H2090021X;
label value ADDSCU42 H2090022X;
label value ADEFRT42 H2090023X;
label value ADEMLS42 H2090024X;
label value ADENGY42 H2090025X;
label value ADFLST42 H2090026X;
label value ADGENH42 H2090027X;
label value ADHDADDX H2090028X;
label value ADHDAGED H2090029X;
label value ADHOPE42 H2090030X;
label value ADINTR42 H2090031X;
label value ADKALC42 H2090032X;
label value ADLANG42 H2090033X;
label value ADLHLP31 H2090034X;
label value ADMDVT42 H2090035X;
label value ADMMGR42 H2090036X;
label value ADMOOD42 H2090037X;
label value ADMWCF42 H2090038X;
label value ADNERV42 H2090039X;
label value ADNOAP42 H2090040X;
label value ADOFTB42 H2090041X;
label value ADOSTP42 H2090042X;
label value ADPAIN42 H2090043X;
label value ADPAP42 H2090044X;
label value ADPAPG42 H2090045X;
label value ADPCFL42 H2090046X;
label value ADPNEU42 H2090047X;
label value ADPROS42 H2090048X;
label value ADPROX42 H2090049X;
label value ADPRST42 H2090050X;
label value ADPSAG42 H2090051X;
label value ADQTHP42 H2090052X;
label value ADQTMD42 H2090053X;
label value ADQTTB42 H2090054X;
label value ADREST42 H2090055X;
label value ADRNK442 H2090056X;
label value ADRNK542 H2090057X;
label value ADSAD42 H2090058X;
label value ADSEX42 H2090059X;
label value ADSGMD42 H2090060X;
label value ADSHNG42 H2090061X;
label value ADSOCA42 H2090062X;
label value ADSTAL42 H2090063X;
label value ADTBAC42 H2090064X;
label value ADUTRM42 H2090065X;
label value ADWGHD42 H2090066X;
label value ADWKLM42 H2090067X;
label value ADWRTH42 H2090068X;
label value ADWTAD42 H2090069X;
label value AFRDCA42 H2090070X;
label value AFRDDN42 H2090071X;
label value AFRDPM42 H2090072X;
label value AFTHOU42 H2090073X;
label value AIDHLP31 H2090074X;
label value ALIIMP18 H2090075X;
label value ANGIAGED H2090076X;
label value ANGIDX H2090077X;
label value ANYLMI18 H2090078X;
label value ARTHAGED H2090079X;
label value ARTHDX H2090080X;
label value ARTHTYPE H2090081X;
label value ASACUT31 H2090082X;
label value ASATAK31 H2090083X;
label value ASDALY31 H2090084X;
label value ASEVFL31 H2090085X;
label value ASIANP42 H2090086X;
label value ASMRCN31 H2090087X;
label value ASPKFL31 H2090088X;
label value ASPREV31 H2090089X;
label value ASSTIL31 H2090090X;
label value ASTHAGED H2090091X;
label value ASTHDX H2090092X;
label value ASTHEP31 H2090093X;
label value ASWNFL31 H2090094X;
label value BEGRFM31 H2090095X;
label value BEGRFM42 H2090096X;
label value BEGRFM53 H2090097X;
label value BEGRFY31 H2090098X;
label value BEGRFY42 H2090099X;
label value BEGRFY53 H2090100X;
label value BENDIF31 H2090101X;
label value BLCKPR42 H2090102X;
label value BOOST42 H2090103X;
label value BORNUSA H2090104X;
label value BPMLDX H2090105X;
label value BSNTY31 H2090106X;
label value BSNTY31H H2090107X;
label value BSNTY42 H2090108X;
label value BSNTY42H H2090109X;
label value BSNTY53 H2090110X;
label value BSNTY53H H2090111X;
label value BUSIMP18 H2090112X;
label value CABLADDR H2090113X;
label value CABREAST H2090114X;
label value CACERVIX H2090115X;
label value CACOLON H2090116X;
label value CALUNG H2090117X;
label value CALYMPH H2090118X;
label value CAMELANO H2090119X;
label value CANCERDX H2090120X;
label value CAOTHER H2090121X;
label value CAPROSTA H2090122X;
label value CASKINDK H2090123X;
label value CASKINNM H2090124X;
label value CAUTERUS H2090125X;
label value CHBMIX42 H2090126X;
label value CHBRON31 H2090127X;
label value CHCOUN42 H2090128X;
label value CHDAGED H2090129X;
label value CHDDX H2090130X;
label value CHEMPB42 H2090131X;
label value CHGJ3142 H2090132X;
label value CHGJ4253 H2090133X;
label value CHLICO42 H2090134X;
label value CHLIHB42 H2090135X;
label value CHLIMI42 H2090136X;
label value CHLIMP18 H2090137X;
label value CHOIC31 H2090138X;
label value CHOIC42 H2090139X;
label value CHOIC53 H2090140X;
label value CHOLAGED H2090141X;
label value CHOLDX H2090142X;
label value CHPMCN42 H2090143X;
label value CHPMED42 H2090144X;
label value CHPMHB42 H2090145X;
label value CHSERV42 H2090146X;
label value CHSRCN42 H2090147X;
label value CHSRHB42 H2090148X;
label value CHTHCO42 H2090149X;
label value CHTHER42 H2090150X;
label value CHTHHB42 H2090151X;
label value CMJHLD31 H2090152X;
label value CMJHLD42 H2090153X;
label value CMJHLD53 H2090154X;
label value COGLIM31 H2090155X;
label value CRFMPY42 H2090156X;
label value CSHCN42 H2090157X;
label value CSHIMP18 H2090158X;
label value DCSELIG H2090159X;
label value DDNWRK18 H2090160X;
label value DECIDE42 H2090161X;
label value DENTIN31 H2090162X;
label value DENTIN42 H2090163X;
label value DENTIN53 H2090164X;
label value DFCOG42 H2090165X;
label value DFDRSB42 H2090166X;
label value DFERND42 H2090167X;
label value DFHEAR42 H2090168X;
label value DFSEE42 H2090169X;
label value DFWLKC42 H2090170X;
label value DIABAGED H2090171X;
label value DIABDX_M18 H2090172X;
label value DIFFWG31 H2090173X;
label value DIFFWG42 H2090174X;
label value DIFFWG53 H2090175X;
label value DISVW31X H2090176X;
label value DISVW42X H2090177X;
label value DISVW53X H2090178X;
label value DIVIMP18 H2090179X;
label value DLAYCA42 H2090180X;
label value DLAYDN42 H2090181X;
label value DLAYPM42 H2090182X;
label value DNTINS18 H2090183X;
label value DNTINS31 H2090184X;
label value DOBMM H2090185X;
label value DOBYY H2090186X;
label value DSA1C53 H2090187X;
label value DSCB1753 H2090188X;
label value DSCGRP53 H2090189X;
label value DSCH1753 H2090190X;
label value DSCH1853 H2090191X;
label value DSCH1953 H2090192X;
label value DSCHNV53 H2090193X;
label value DSCINT53 H2090194X;
label value DSCNPC53 H2090195X;
label value DSCONF53 H2090196X;
label value DSCPCP53 H2090197X;
label value DSCPHN53 H2090198X;
label value DSDIA53 H2090199X;
label value DSDIET53 H2090200X;
label value DSEB1753 H2090201X;
label value DSEY1753 H2090202X;
label value DSEY1853 H2090203X;
label value DSEY1953 H2090204X;
label value DSEYNV53 H2090205X;
label value DSEYPR53 H2090206X;
label value DSFB1753 H2090207X;
label value DSFL1753 H2090208X;
label value DSFL1853 H2090209X;
label value DSFL1953 H2090210X;
label value DSFLNV53 H2090211X;
label value DSFT1753 H2090212X;
label value DSFT1853 H2090213X;
label value DSFT1953 H2090214X;
label value DSFTNV53 H2090215X;
label value DSINSU53 H2090216X;
label value DSKIDN53 H2090217X;
label value DSMED53 H2090218X;
label value DSPRX53 H2090219X;
label value DSVB1753 H2090220X;
label value DVTOT18 H2090221X;
label value EATHLT42 H2090222X;
label value EDUCYR H2090223X;
label value ELGRND18 H2090224X;
label value ELGRND31 H2090225X;
label value ELGRND42 H2090226X;
label value ELGRND53 H2090227X;
label value EMPHAGED H2090228X;
label value EMPHDX H2090229X;
label value EMPST31 H2090230X;
label value EMPST31H H2090231X;
label value EMPST42 H2090232X;
label value EMPST42H H2090233X;
label value EMPST53 H2090234X;
label value EMPST53H H2090235X;
label value ENDRFM18 H2090236X;
label value ENDRFM31 H2090237X;
label value ENDRFM42 H2090238X;
label value ENDRFM53 H2090239X;
label value ENDRFY18 H2090240X;
label value ENDRFY31 H2090241X;
label value ENDRFY42 H2090242X;
label value ENDRFY53 H2090243X;
label value ERTOT18 H2090244X;
label value EVRETIRE H2090245X;
label value EVRWRK H2090246X;
label value EXPLOP42 H2090247X;
label value FAMRFPYR H2090248X;
label value FAMSZE31 H2090249X;
label value FAMSZE42 H2090250X;
label value FAMSZE53 H2090251X;
label value FCRP1231 H2090252X;
label value FILEDR18 H2090253X;
label value FILER18 H2090254X;
label value FLSTAT18 H2090255X;
label value FMRS1231 H2090256X;
label value FNGRDF31 H2090257X;
label value FOODMN18 H2090258X;
label value FOODST18 H2090259X;
label value FOODVL18 H2090260X;
label value FSAGT31 H2090261X;
label value FTSTU18X H2090262X;
label value FTSTU31X H2090263X;
label value FTSTU42X H2090264X;
label value FTSTU53X H2090265X;
label value GENDRP42 H2090266X;
label value GOVAAT18 H2090267X;
label value GOVAAT31 H2090268X;
label value GOVAAT42 H2090269X;
label value GOVAAT53 H2090270X;
label value GOVBAT18 H2090271X;
label value GOVBAT31 H2090272X;
label value GOVBAT42 H2090273X;
label value GOVBAT53 H2090274X;
label value GOVCAT18 H2090275X;
label value GOVCAT31 H2090276X;
label value GOVCAT42 H2090277X;
label value GOVCAT53 H2090278X;
label value GOVTA18 H2090279X;
label value GOVTA31 H2090280X;
label value GOVTA42 H2090281X;
label value GOVTA53 H2090282X;
label value GOVTB18 H2090283X;
label value GOVTB31 H2090284X;
label value GOVTB42 H2090285X;
label value GOVTB53 H2090286X;
label value GOVTC18 H2090287X;
label value GOVTC31 H2090288X;
label value GOVTC42 H2090289X;
label value GOVTC53 H2090290X;
label value GVAAP18 H2090291X;
label value GVAAU18 H2090292X;
label value GVADE18 H2090293X;
label value GVAEV18 H2090294X;
label value GVAFE18 H2090295X;
label value GVAJA18 H2090296X;
label value GVAJL18 H2090297X;
label value GVAJU18 H2090298X;
label value GVAMA18 H2090299X;
label value GVAMY18 H2090300X;
label value GVANO18 H2090301X;
label value GVAOC18 H2090302X;
label value GVASE18 H2090303X;
label value GVBAP18 H2090304X;
label value GVBAU18 H2090305X;
label value GVBDE18 H2090306X;
label value GVBEV18 H2090307X;
label value GVBFE18 H2090308X;
label value GVBJA18 H2090309X;
label value GVBJL18 H2090310X;
label value GVBJU18 H2090311X;
label value GVBMA18 H2090312X;
label value GVBMY18 H2090313X;
label value GVBNO18 H2090314X;
label value GVBOC18 H2090315X;
label value GVBSE18 H2090316X;
label value GVCAP18 H2090317X;
label value GVCAU18 H2090318X;
label value GVCDE18 H2090319X;
label value GVCEV18 H2090320X;
label value GVCFE18 H2090321X;
label value GVCJA18 H2090322X;
label value GVCJL18 H2090323X;
label value GVCJU18 H2090324X;
label value GVCMA18 H2090325X;
label value GVCMY18 H2090326X;
label value GVCNO18 H2090327X;
label value GVCOC18 H2090328X;
label value GVCSE18 H2090329X;
label value HASFSA31 H2090330X;
label value HAVEUS42 H2090331X;
label value HELD31X H2090332X;
label value HELD42X H2090333X;
label value HELD53X H2090334X;
label value HELMET42 H2090335X;
label value HHAGD18 H2090336X;
label value HHINDD18 H2090337X;
label value HHINFD18 H2090338X;
label value HHTOTD18 H2090339X;
label value HIBPAGED H2090340X;
label value HIBPDX H2090341X;
label value HIDEG H2090342X;
label value HISPANX H2090343X;
label value HISPNCAT H2090344X;
label value HONRDC31 H2090345X;
label value HONRDC42 H2090346X;
label value HOUR31 H2090347X;
label value HOUR42 H2090348X;
label value HOUR53 H2090349X;
label value HPDAP18 H2090350X;
label value HPDAU18 H2090351X;
label value HPDDE18 H2090352X;
label value HPDFE18 H2090353X;
label value HPDJA18 H2090354X;
label value HPDJL18 H2090355X;
label value HPDJU18 H2090356X;
label value HPDMA18 H2090357X;
label value HPDMY18 H2090358X;
label value HPDNO18 H2090359X;
label value HPDOC18 H2090360X;
label value HPDSE18 H2090361X;
label value HPEAP18 H2090362X;
label value HPEAU18 H2090363X;
label value HPEDE18 H2090364X;
label value HPEFE18 H2090365X;
label value HPEJA18 H2090366X;
label value HPEJL18 H2090367X;
label value HPEJU18 H2090368X;
label value HPEMA18 H2090369X;
label value HPEMY18 H2090370X;
label value HPENO18 H2090371X;
label value HPEOC18 H2090372X;
label value HPESE18 H2090373X;
label value HPNAP18 H2090374X;
label value HPNAU18 H2090375X;
label value HPNDE18 H2090376X;
label value HPNFE18 H2090377X;
label value HPNJA18 H2090378X;
label value HPNJL18 H2090379X;
label value HPNJU18 H2090380X;
label value HPNMA18 H2090381X;
label value HPNMY18 H2090382X;
label value HPNNO18 H2090383X;
label value HPNOC18 H2090384X;
label value HPNSE18 H2090385X;
label value HPOAP18 H2090386X;
label value HPOAU18 H2090387X;
label value HPODE18 H2090388X;
label value HPOFE18 H2090389X;
label value HPOJA18 H2090390X;
label value HPOJL18 H2090391X;
label value HPOJU18 H2090392X;
label value HPOMA18 H2090393X;
label value HPOMY18 H2090394X;
label value HPONO18 H2090395X;
label value HPOOC18 H2090396X;
label value HPOSE18 H2090397X;
label value HPRAP18 H2090398X;
label value HPRAU18 H2090399X;
label value HPRDE18 H2090400X;
label value HPRFE18 H2090401X;
label value HPRJA18 H2090402X;
label value HPRJL18 H2090403X;
label value HPRJU18 H2090404X;
label value HPRMA18 H2090405X;
label value HPRMY18 H2090406X;
label value HPRNO18 H2090407X;
label value HPROC18 H2090408X;
label value HPRSE18 H2090409X;
label value HPXAP18 H2090410X;
label value HPXAU18 H2090411X;
label value HPXDE18 H2090412X;
label value HPXFE18 H2090413X;
label value HPXJA18 H2090414X;
label value HPXJL18 H2090415X;
label value HPXJU18 H2090416X;
label value HPXMA18 H2090417X;
label value HPXMY18 H2090418X;
label value HPXNO18 H2090419X;
label value HPXOC18 H2090420X;
label value HPXSE18 H2090421X;
label value HRHOW31 H2090422X;
label value HRHOW42 H2090423X;
label value HRHOW53 H2090424X;
label value HRWG31H H2090425X;
label value HRWG31X H2090426X;
label value HRWG42H H2090427X;
label value HRWG42X H2090428X;
label value HRWG53H H2090429X;
label value HRWG53X H2090430X;
label value HRWGIM31 H2090431X;
label value HRWGIM42 H2090432X;
label value HRWGIM53 H2090433X;
label value HSELIM31 H2090434X;
label value HSPLAP42 H2090435X;
label value HWELLSPE H2090436X;
label value HWELLSPK H2090437X;
label value IADLHP31 H2090438X;
label value IHS18 H2090439X;
label value IHS31 H2090440X;
label value IHS42 H2090441X;
label value IHS53 H2090442X;
label value IHSAP18 H2090443X;
label value IHSAT18 H2090444X;
label value IHSAT31 H2090445X;
label value IHSAT42 H2090446X;
label value IHSAT53 H2090447X;
label value IHSAU18 H2090448X;
label value IHSDE18 H2090449X;
label value IHSFE18 H2090450X;
label value IHSJA18 H2090451X;
label value IHSJL18 H2090452X;
label value IHSJU18 H2090453X;
label value IHSMA18 H2090454X;
label value IHSMY18 H2090455X;
label value IHSNO18 H2090456X;
label value IHSOC18 H2090457X;
label value IHSSE18 H2090458X;
label value INDCAT31 H2090459X;
label value INDCAT42 H2090460X;
label value INDCAT53 H2090461X;
label value INDCT31H H2090462X;
label value INDCT42H H2090463X;
label value INDCT53H H2090464X;
label value INS18X H2090465X;
label value INS31X H2090466X;
label value INS42X H2090467X;
label value INS53X H2090468X;
label value INSAP18X H2090469X;
label value INSAT18X H2090470X;
label value INSAT31X H2090471X;
label value INSAT42X H2090472X;
label value INSAT53X H2090473X;
label value INSAU18X H2090474X;
label value INSC1231 H2090475X;
label value INSCOP18 H2090476X;
label value INSCOP31 H2090477X;
label value INSCOP42 H2090478X;
label value INSCOP53 H2090479X;
label value INSCOPE H2090480X;
label value INSCOV18 H2090481X;
label value INSDE18X H2090482X;
label value INSFE18X H2090483X;
label value INSJA18X H2090484X;
label value INSJL18X H2090485X;
label value INSJU18X H2090486X;
label value INSMA18X H2090487X;
label value INSMY18X H2090488X;
label value INSNO18X H2090489X;
label value INSOC18X H2090490X;
label value INSSE18X H2090491X;
label value INSURC18 H2090492X;
label value INTIMP18 H2090493X;
label value INTVLANG H2090494X;
label value IPDIS18 H2090495X;
label value IPNGTD18 H2090496X;
label value IRAIMP18 H2090497X;
label value JBORG31H H2090498X;
label value JBORG42H H2090499X;
label value JBORG53H H2090500X;
label value JNTPID18 H2090501X;
label value JOBORG31 H2090502X;
label value JOBORG42 H2090503X;
label value JOBORG53 H2090504X;
label value JTINRU18 H2090505X;
label value JTPAIN31_M18 H2090506X;
label value K6SUM42 H2090507X;
label value KEYNESS H2090508X;
label value LANGSPK H2090509X;
label value LAPBLT42 H2090510X;
label value LFTDIF31 H2090511X;
label value LOCATN42 H2090512X;
label value LSTETH53 H2090513X;
label value MARRY18X H2090514X;
label value MARRY31X H2090515X;
label value MARRY42X H2090516X;
label value MARRY53X H2090517X;
label value MCAID18 H2090518X;
label value MCAID18X H2090519X;
label value MCAID31 H2090520X;
label value MCAID31X H2090521X;
label value MCAID42 H2090522X;
label value MCAID42X H2090523X;
label value MCAID53 H2090524X;
label value MCAID53X H2090525X;
label value MCARE18 H2090526X;
label value MCARE18X H2090527X;
label value MCARE31 H2090528X;
label value MCARE31X H2090529X;
label value MCARE42 H2090530X;
label value MCARE42X H2090531X;
label value MCARE53 H2090532X;
label value MCARE53X H2090533X;
label value MCDAP18 H2090534X;
label value MCDAP18X H2090535X;
label value MCDAT18X H2090536X;
label value MCDAT31X H2090537X;
label value MCDAT42X H2090538X;
label value MCDAT53X H2090539X;
label value MCDAU18 H2090540X;
label value MCDAU18X H2090541X;
label value MCDDE18 H2090542X;
label value MCDDE18X H2090543X;
label value MCDEV18 H2090544X;
label value MCDFE18 H2090545X;
label value MCDFE18X H2090546X;
label value MCDHMO18 H2090547X;
label value MCDHMO31 H2090548X;
label value MCDHMO42 H2090549X;
label value MCDJA18 H2090550X;
label value MCDJA18X H2090551X;
label value MCDJL18 H2090552X;
label value MCDJL18X H2090553X;
label value MCDJU18 H2090554X;
label value MCDJU18X H2090555X;
label value MCDMA18 H2090556X;
label value MCDMA18X H2090557X;
label value MCDMC18 H2090558X;
label value MCDMC31 H2090559X;
label value MCDMC42 H2090560X;
label value MCDMY18 H2090561X;
label value MCDMY18X H2090562X;
label value MCDNO18 H2090563X;
label value MCDNO18X H2090564X;
label value MCDOC18 H2090565X;
label value MCDOC18X H2090566X;
label value MCDSE18 H2090567X;
label value MCDSE18X H2090568X;
label value MCRAP18 H2090569X;
label value MCRAP18X H2090570X;
label value MCRAU18 H2090571X;
label value MCRAU18X H2090572X;
label value MCRDE18 H2090573X;
label value MCRDE18X H2090574X;
label value MCREV18 H2090575X;
label value MCRFE18 H2090576X;
label value MCRFE18X H2090577X;
label value MCRJA18 H2090578X;
label value MCRJA18X H2090579X;
label value MCRJL18 H2090580X;
label value MCRJL18X H2090581X;
label value MCRJU18 H2090582X;
label value MCRJU18X H2090583X;
label value MCRMA18 H2090584X;
label value MCRMA18X H2090585X;
label value MCRMY18 H2090586X;
label value MCRMY18X H2090587X;
label value MCRNO18 H2090588X;
label value MCRNO18X H2090589X;
label value MCROC18 H2090590X;
label value MCROC18X H2090591X;
label value MCRPB18 H2090592X;
label value MCRPB31 H2090593X;
label value MCRPB42 H2090594X;
label value MCRPD18 H2090595X;
label value MCRPD18X H2090596X;
label value MCRPD31 H2090597X;
label value MCRPD31X H2090598X;
label value MCRPD42 H2090599X;
label value MCRPD42X H2090600X;
label value MCRPHO18 H2090601X;
label value MCRPHO31 H2090602X;
label value MCRPHO42 H2090603X;
label value MCRSE18 H2090604X;
label value MCRSE18X H2090605X;
label value MESHGT42 H2090606X;
label value MESVIS42 H2090607X;
label value MESWGT42 H2090608X;
label value MIAGED H2090609X;
label value MIDX H2090610X;
label value MILDIF31 H2090611X;
label value MNHLTH31 H2090612X;
label value MNHLTH42 H2090613X;
label value MNHLTH53 H2090614X;
label value MORE31 H2090615X;
label value MORE31H H2090616X;
label value MORE42 H2090617X;
label value MORE42H H2090618X;
label value MORE53 H2090619X;
label value MORE53H H2090620X;
label value MORECOVR H2090621X;
label value MORJOB31 H2090622X;
label value MORJOB42 H2090623X;
label value MORJOB53 H2090624X;
label value NATAMP42 H2090625X;
label value NHRWG31 H2090626X;
label value NHRWG42 H2090627X;
label value NHRWG53 H2090628X;
label value NOSMOK42 H2090629X;
label value NUMEMP31 H2090630X;
label value NUMEMP42 H2090631X;
label value NUMEMP53 H2090632X;
label value NWK31 H2090633X;
label value NWK42 H2090634X;
label value NWK53 H2090635X;
label value OBDRV18 H2090636X;
label value OBTOTV18 H2090637X;
label value OCCCAT31 H2090638X;
label value OCCCAT42 H2090639X;
label value OCCCAT53 H2090640X;
label value OCCCT31H H2090641X;
label value OCCCT42H H2090642X;
label value OCCCT53H H2090643X;
label value OFEMP31H H2090644X;
label value OFEMP42H H2090645X;
label value OFEMP53H H2090646X;
label value OFFER31H H2090647X;
label value OFFER31X H2090648X;
label value OFFER42H H2090649X;
label value OFFER42X H2090650X;
label value OFFER53H H2090651X;
label value OFFER53X H2090652X;
label value OFFHOU42 H2090653X;
label value OFREMP31 H2090654X;
label value OFREMP42 H2090655X;
label value OFREMP53 H2090656X;
label value OFTSMK53 H2090657X;
label value OHRTAGED H2090658X;
label value OHRTDX H2090659X;
label value OHRTTYPE H2090660X;
label value OPDRV18 H2090661X;
label value OPTOTV18 H2090662X;
label value OTHDYS18 H2090663X;
label value OTHIMP18 H2090664X;
label value OTHLANG H2090665X;
label value OTHLGSPK H2090666X;
label value OTHNDD18 H2090667X;
label value OTHRCP42 H2090668X;
label value PACISP42 H2090669X;
label value PANEL H2090670X;
label value PAYDR31 H2090671X;
label value PAYDR31H H2090672X;
label value PAYDR42 H2090673X;
label value PAYDR42H H2090674X;
label value PAYDR53 H2090675X;
label value PAYDR53H H2090676X;
label value PAYVAC31 H2090677X;
label value PAYVAC42 H2090678X;
label value PAYVAC53 H2090679X;
label value PDKAP18 H2090680X;
label value PDKAU18 H2090681X;
label value PDKDE18 H2090682X;
label value PDKFE18 H2090683X;
label value PDKJA18 H2090684X;
label value PDKJL18 H2090685X;
label value PDKJU18 H2090686X;
label value PDKMA18 H2090687X;
label value PDKMY18 H2090688X;
label value PDKNO18 H2090689X;
label value PDKOC18 H2090690X;
label value PDKSE18 H2090691X;
label value PEGAP18 H2090692X;
label value PEGAU18 H2090693X;
label value PEGDE18 H2090694X;
label value PEGFE18 H2090695X;
label value PEGJA18 H2090696X;
label value PEGJL18 H2090697X;
label value PEGJU18 H2090698X;
label value PEGMA18 H2090699X;
label value PEGMY18 H2090700X;
label value PEGNO18 H2090701X;
label value PEGOC18 H2090702X;
label value PEGSE18 H2090703X;
label value PENIMP18 H2090704X;
label value PFSAMT31 H2090705X;
label value PHNREG42 H2090706X;
label value PHQ242 H2090707X;
label value PHYEXE53 H2090708X;
label value PHYSCL42 H2090709X;
label value PLCTYP42 H2090710X;
label value PMDINS18 H2090711X;
label value PMDINS31 H2090712X;
label value PMEDIN31 H2090713X;
label value PMEDIN42 H2090714X;
label value PMEDIN53 H2090715X;
label value PMEDPY31 H2090716X;
label value PMEDPY42 H2090717X;
label value PMEDPY53 H2090718X;
label value PMEDUP31 H2090719X;
label value PMEDUP42 H2090720X;
label value PMEDUP53 H2090721X;
label value PNEAP18 H2090722X;
label value PNEAU18 H2090723X;
label value PNEDE18 H2090724X;
label value PNEFE18 H2090725X;
label value PNEJA18 H2090726X;
label value PNEJL18 H2090727X;
label value PNEJU18 H2090728X;
label value PNEMA18 H2090729X;
label value PNEMY18 H2090730X;
label value PNENO18 H2090731X;
label value PNEOC18 H2090732X;
label value PNESE18 H2090733X;
label value PNGAP18 H2090734X;
label value PNGAU18 H2090735X;
label value PNGDE18 H2090736X;
label value PNGFE18 H2090737X;
label value PNGJA18 H2090738X;
label value PNGJL18 H2090739X;
label value PNGJU18 H2090740X;
label value PNGMA18 H2090741X;
label value PNGMY18 H2090742X;
label value PNGNO18 H2090743X;
label value PNGOC18 H2090744X;
label value PNGSE18 H2090745X;
label value POEAP18 H2090746X;
label value POEAU18 H2090747X;
label value POEDE18 H2090748X;
label value POEFE18 H2090749X;
label value POEJA18 H2090750X;
label value POEJL18 H2090751X;
label value POEJU18 H2090752X;
label value POEMA18 H2090753X;
label value POEMY18 H2090754X;
label value POENO18 H2090755X;
label value POEOC18 H2090756X;
label value POESE18 H2090757X;
label value POGAP18 H2090758X;
label value POGAU18 H2090759X;
label value POGDE18 H2090760X;
label value POGFE18 H2090761X;
label value POGJA18 H2090762X;
label value POGJL18 H2090763X;
label value POGJU18 H2090764X;
label value POGMA18 H2090765X;
label value POGMY18 H2090766X;
label value POGNO18 H2090767X;
label value POGOC18 H2090768X;
label value POGSE18 H2090769X;
label value POVCAT18 H2090770X;
label value PRACTP42 H2090771X;
label value PREVCOVR H2090772X;
label value PRIAP18 H2090773X;
label value PRIAU18 H2090774X;
label value PRIDE18 H2090775X;
label value PRIDK18 H2090776X;
label value PRIDK31 H2090777X;
label value PRIDK42 H2090778X;
label value PRIDK53 H2090779X;
label value PRIEU18 H2090780X;
label value PRIEU31 H2090781X;
label value PRIEU42 H2090782X;
label value PRIEU53 H2090783X;
label value PRIEUO18 H2090784X;
label value PRIEUO31 H2090785X;
label value PRIEUO42 H2090786X;
label value PRIEUO53 H2090787X;
label value PRIFE18 H2090788X;
label value PRIJA18 H2090789X;
label value PRIJL18 H2090790X;
label value PRIJU18 H2090791X;
label value PRIMA18 H2090792X;
label value PRIMY18 H2090793X;
label value PRINEO18 H2090794X;
label value PRINEO31 H2090795X;
label value PRINEO42 H2090796X;
label value PRINEO53 H2090797X;
label value PRING18 H2090798X;
label value PRING31 H2090799X;
label value PRING42 H2090800X;
label value PRING53 H2090801X;
label value PRINO18 H2090802X;
label value PRIOC18 H2090803X;
label value PRIOG18 H2090804X;
label value PRIOG31 H2090805X;
label value PRIOG42 H2090806X;
label value PRIOG53 H2090807X;
label value PRISE18 H2090808X;
label value PRIV18 H2090809X;
label value PRIV31 H2090810X;
label value PRIV42 H2090811X;
label value PRIV53 H2090812X;
label value PRIVAT18 H2090813X;
label value PRIVAT31 H2090814X;
label value PRIVAT42 H2090815X;
label value PRIVAT53 H2090816X;
label value PROBPY42 H2090817X;
label value PROVTY42_M18 H2090818X;
label value PROXY18 H2090819X;
label value PROXY31 H2090820X;
label value PROXY42 H2090821X;
label value PROXY53 H2090822X;
label value PRSTX18 H2090823X;
label value PRSTX31 H2090824X;
label value PRSTX42 H2090825X;
label value PRSTX53 H2090826X;
label value PRVEV18 H2090827X;
label value PRVHMO18 H2090828X;
label value PRVHMO31 H2090829X;
label value PRVHMO42 H2090830X;
label value PRVSPK42 H2090831X;
label value PRXAP18 H2090832X;
label value PRXAU18 H2090833X;
label value PRXDE18 H2090834X;
label value PRXFE18 H2090835X;
label value PRXJA18 H2090836X;
label value PRXJL18 H2090837X;
label value PRXJU18 H2090838X;
label value PRXMA18 H2090839X;
label value PRXMY18 H2090840X;
label value PRXNO18 H2090841X;
label value PRXOC18 H2090842X;
label value PRXSE18 H2090843X;
label value PSTATS31 H2090844X;
label value PSTATS42 H2090845X;
label value PSTATS53 H2090846X;
label value PUB18X H2090847X;
label value PUB31X H2090848X;
label value PUB42X H2090849X;
label value PUB53X H2090850X;
label value PUBAP18X H2090851X;
label value PUBAT18X H2090852X;
label value PUBAT31X H2090853X;
label value PUBAT42X H2090854X;
label value PUBAT53X H2090855X;
label value PUBAU18X H2090856X;
label value PUBDE18X H2090857X;
label value PUBFE18X H2090858X;
label value PUBIMP18 H2090859X;
label value PUBJA18X H2090860X;
label value PUBJL18X H2090861X;
label value PUBJU18X H2090862X;
label value PUBMA18X H2090863X;
label value PUBMY18X H2090864X;
label value PUBNO18X H2090865X;
label value PUBOC18X H2090866X;
label value PUBSE18X H2090867X;
label value PYUNBL42 H2090868X;
label value PYVAC31H H2090869X;
label value PYVAC42H H2090870X;
label value PYVAC53H H2090871X;
label value RACEAX H2090872X;
label value RACEBX H2090873X;
label value RACETHX H2090874X;
label value RACEV1X H2090875X;
label value RACEV2X H2090876X;
label value RACEWX H2090877X;
label value RCHDIF31 H2090878X;
label value REFRL18X H2090879X;
label value REFRL31X H2090880X;
label value REFRL42X H2090881X;
label value REFRL53X H2090882X;
label value REGION18 H2090883X;
label value REGION31 H2090884X;
label value REGION42 H2090885X;
label value REGION53 H2090886X;
label value RESP18 H2090887X;
label value RESP31 H2090888X;
label value RESP42 H2090889X;
label value RESP53 H2090890X;
label value RETPLN31 H2090891X;
label value RETPLN42 H2090892X;
label value RETPLN53 H2090893X;
label value RNDFLG31 H2090894X;
label value RTHLTH31 H2090895X;
label value RTHLTH42 H2090896X;
label value RTHLTH53 H2090897X;
label value RTPLN31H H2090898X;
label value RTPLN42H H2090899X;
label value RTPLN53H H2090900X;
label value RUCLAS18 H2090901X;
label value RUCLAS31 H2090902X;
label value RUCLAS42 H2090903X;
label value RUCLAS53 H2090904X;
label value RUSIZE18 H2090905X;
label value RUSIZE31 H2090906X;
label value RUSIZE42 H2090907X;
label value RUSIZE53 H2090908X;
label value SAFEST42 H2090909X;
label value SALIMP18 H2090910X;
label value SAQELIG H2090911X;
label value SCHLIM31 H2090912X;
label value SCPAY31H H2090913X;
label value SCPAY42H H2090914X;
label value SCPAY53H H2090915X;
label value SELFCM31 H2090916X;
label value SELFCM42 H2090917X;
label value SELFCM53 H2090918X;
label value SEX H2090919X;
label value SICPAY31 H2090920X;
label value SICPAY42 H2090921X;
label value SICPAY53 H2090922X;
label value SLFCM31H H2090923X;
label value SLFCM42H H2090924X;
label value SLFCM53H H2090925X;
label value SOCLIM31 H2090926X;
label value SPOUID18 H2090927X;
label value SPOUID31 H2090928X;
label value SPOUID42 H2090929X;
label value SPOUID53 H2090930X;
label value SPOUIN18 H2090931X;
label value SPOUIN31 H2090932X;
label value SPOUIN42 H2090933X;
label value SPOUIN53 H2090934X;
label value SSCIMP18 H2090935X;
label value SSIIMP18 H2090936X;
label value SSNLJB31 H2090937X;
label value SSNLJB42 H2090938X;
label value SSNLJB53 H2090939X;
label value STJBMM31 H2090940X;
label value STJBMM42 H2090941X;
label value STJBMM53 H2090942X;
label value STJBYY31 H2090943X;
label value STJBYY42 H2090944X;
label value STJBYY53 H2090945X;
label value STNDIF31 H2090946X;
label value STPDIF31 H2090947X;
label value STRKAGED H2090948X;
label value STRKDX H2090949X;
label value TAXFRM18 H2090950X;
label value TEMPJB31 H2090951X;
label value TEMPJB42 H2090952X;
label value TEMPJB53 H2090953X;
label value TIMALN42 H2090954X;
label value TMTKUS42 H2090955X;
label value TREATM42 H2090956X;
label value TRIAP18X H2090957X;
label value TRIAT18X H2090958X;
label value TRIAT31X H2090959X;
label value TRIAT42X H2090960X;
label value TRIAT53X H2090961X;
label value TRIAU18X H2090962X;
label value TRICH18X H2090963X;
label value TRICH31X H2090964X;
label value TRICH42X H2090965X;
label value TRICR18X H2090966X;
label value TRICR31X H2090967X;
label value TRICR42X H2090968X;
label value TRICR53X H2090969X;
label value TRIDE18X H2090970X;
label value TRIEV18 H2090971X;
label value TRIEX18X H2090972X;
label value TRIEX31X H2090973X;
label value TRIEX42X H2090974X;
label value TRIFE18X H2090975X;
label value TRIJA18X H2090976X;
label value TRIJL18X H2090977X;
label value TRIJU18X H2090978X;
label value TRILI18X H2090979X;
label value TRILI31X H2090980X;
label value TRILI42X H2090981X;
label value TRIMA18X H2090982X;
label value TRIMY18X H2090983X;
label value TRINO18X H2090984X;
label value TRIOC18X H2090985X;
label value TRIPR18X H2090986X;
label value TRIPR31X H2090987X;
label value TRIPR42X H2090988X;
label value TRISE18X H2090989X;
label value TRIST18X H2090990X;
label value TRIST31X H2090991X;
label value TRIST42X H2090992X;
label value TRTIMP18 H2090993X;
label value TYPEPE42 H2090994X;
label value UNABLE31 H2090995X;
label value UNEIMP18 H2090996X;
label value UNINS18 H2090997X;
label value UNION31 H2090998X;
label value UNION31H H2090999X;
label value UNION42 H2091000X;
label value UNION42H H2091001X;
label value UNION53 H2091002X;
label value UNION53H H2091003X;
label value VABACK53 H2091004X;
label value VABIPL53 H2091005X;
label value VACARC53 H2091006X;
label value VACARE53 H2091007X;
label value VACMPM53 H2091008X;
label value VACMPY53 H2091009X;
label value VACOMP53 H2091010X;
label value VACOPD53 H2091011X;
label value VACOST53 H2091012X;
label value VACRGV53 H2091013X;
label value VACTDY53 H2091014X;
label value VADEPR53 H2091015X;
label value VADERM53 H2091016X;
label value VAEV18 H2091017X;
label value VAGCNS53 H2091018X;
label value VAGERD53 H2091019X;
label value VAGOUT53 H2091020X;
label value VAGTRC53 H2091021X;
label value VAHRLS53 H2091022X;
label value VAJTPN53 H2091023X;
label value VALCOH53 H2091024X;
label value VALOCT53 H2091025X;
label value VAMNHC53 H2091026X;
label value VAMOBL53 H2091027X;
label value VAMOOD53 H2091028X;
label value VAMREC53 H2091029X;
label value VANECK53 H2091030X;
label value VANEED53 H2091031X;
label value VANTWK53 H2091032X;
label value VAOUT53 H2091033X;
label value VAPACT53 H2091034X;
label value VAPAP18 H2091035X;
label value VAPAST53 H2091036X;
label value VAPAU18 H2091037X;
label value VAPCCO53 H2091038X;
label value VAPCOT53 H2091039X;
label value VAPCOU53 H2091040X;
label value VAPCPR53 H2091041X;
label value VAPCRC53 H2091042X;
label value VAPCRF53 H2091043X;
label value VAPCSN53 H2091044X;
label value VAPCSO53 H2091045X;
label value VAPCUN53 H2091046X;
label value VAPDE18 H2091047X;
label value VAPFE18 H2091048X;
label value VAPJA18 H2091049X;
label value VAPJL18 H2091050X;
label value VAPJU18 H2091051X;
label value VAPMA18 H2091052X;
label value VAPMY18 H2091053X;
label value VAPNO18 H2091054X;
label value VAPOC18 H2091055X;
label value VAPRAT18 H2091056X;
label value VAPRAT31 H2091057X;
label value VAPRAT42 H2091058X;
label value VAPRAT53 H2091059X;
label value VAPRHT53 H2091060X;
label value VAPROB53 H2091061X;
label value VAPROG18 H2091062X;
label value VAPROG31 H2091063X;
label value VAPROG42 H2091064X;
label value VAPROG53 H2091065X;
label value VAPROS53 H2091066X;
label value VAPROV53 H2091067X;
label value VAPROX53 H2091068X;
label value VAPSE18 H2091069X;
label value VAPTSD53 H2091070X;
label value VARECM53 H2091071X;
label value VAREP53 H2091072X;
label value VARHAB53 H2091073X;
label value VARTHR53 H2091074X;
label value VARXMD53 H2091075X;
label value VASPCL53 H2091076X;
label value VASPMH53 H2091077X;
label value VASPOU53 H2091078X;
label value VASPUN53 H2091079X;
label value VATMD53 H2091080X;
label value VAWAIT53 H2091081X;
label value VERFLG18 H2091082X;
label value VERFLG31 H2091083X;
label value VERFLG42 H2091084X;
label value VETIMP18 H2091085X;
label value VMCS42 H2091086X;
label value VPCS42 H2091087X;
label value VRFLAG42 H2091088X;
label value VSAQELIG H2091089X;
label value WAGIMP18 H2091090X;
label value WCPIMP18 H2091091X;
label value WHITPR42 H2091092X;
label value WHNBST42 H2091093X;
label value WHNEAT42 H2091094X;
label value WHNHEL42 H2091095X;
label value WHNHGT42 H2091096X;
label value WHNLAP42 H2091097X;
label value WHNPHY42 H2091098X;
label value WHNSAF42 H2091099X;
label value WHNSMK42 H2091100X;
label value WHNWGT42 H2091101X;
label value WHTLGSPK H2091102X;
label value WILFIL18 H2091103X;
label value WLKDIF31 H2091104X;
label value WLKLIM31 H2091105X;
label value WRKLIM31 H2091106X;
label value YCHJ3142 H2091107X;
label value YCHJ4253 H2091108X;
label value YNOUSC42_M18 H2091109X;
label value YRSINUS H2091110X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H209.LOG and a data file named H209.DTA.  If these files (H209.DTA and H209.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

